/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleKeysMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedDoubleSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

public abstract class AbstractMutableDoubleKeySet
implements MutableDoubleSet {
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !AbstractMutableDoubleKeySet.isEmptyKey(key) && !AbstractMutableDoubleKeySet.isRemovedKey(key);
    }

    protected abstract double getKeyAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract MutableDoubleKeysMap getOuter();

    protected abstract AbstractSentinelValues getSentinelValues();

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        this.getOuter().forEachKey(procedure);
    }

    public int count(DoublePredicate predicate) {
        int count = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                ++count;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                ++count;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(0.0)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(1.0)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(double element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(double ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(DoubleIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleSet select(DoublePredicate predicate) {
        DoubleHashSet result = new DoubleHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                result.add(0.0);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                result.add(1.0);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    public MutableDoubleSet reject(DoublePredicate predicate) {
        DoubleHashSet result = new DoubleHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(0.0)) {
                result.add(0.0);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(1.0)) {
                result.add(1.0);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    public MutableDoubleSet with(double element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleSet without(double element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleSet withAll(DoubleIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleSet withoutAll(DoubleIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        MutableSet result = Sets.mutable.with();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result.add(function.valueOf(0.0));
            }
            if (this.getSentinelValues().containsOneKey) {
                result.add(function.valueOf(1.0));
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result.add(function.valueOf(this.getKeyAtIndex(i)));
        }
        return result;
    }

    public boolean remove(double key) {
        int oldSize = this.getOuter().size();
        this.getOuter().removeKey(key);
        return oldSize != this.getOuter().size();
    }

    public boolean removeAll(DoubleIterable source) {
        int oldSize = this.getOuter().size();
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            this.getOuter().removeKey(iterator.next());
        }
        return oldSize != this.getOuter().size();
    }

    public boolean removeAll(double ... source) {
        int oldSize = this.getOuter().size();
        for (double item : source) {
            this.getOuter().removeKey(item);
        }
        return oldSize != this.getOuter().size();
    }

    public void clear() {
        this.getOuter().clear();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(0.0)) {
                return 0.0;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(1.0)) {
                return 1.0;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return this.getKeyAtIndex(i);
        }
        return ifNone;
    }

    public MutableDoubleSet asUnmodifiable() {
        return UnmodifiableDoubleSet.of(this);
    }

    public MutableDoubleSet asSynchronized() {
        return SynchronizedDoubleSet.of(this);
    }

    public double sum() {
        double result = 0.0;
        double compensation = 0.0;
        if (this.getSentinelValues() != null) {
            double nextSum;
            double adjustedValue;
            if (this.getSentinelValues().containsZeroKey) {
                adjustedValue = 0.0 - compensation;
                nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
            if (this.getSentinelValues().containsOneKey) {
                adjustedValue = 1.0 - compensation;
                nextSum = result + adjustedValue;
                compensation = nextSum - result - adjustedValue;
                result = nextSum;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            double adjustedValue = this.getKeyAtIndex(i) - compensation;
            double nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        return result;
    }

    public double max() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        double max = 0.0;
        boolean isMaxSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                max = 0.0;
                isMaxSet = true;
            }
            if (this.getSentinelValues().containsOneKey) {
                max = 1.0;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMaxSet && Double.compare(max, this.getKeyAtIndex(i)) >= 0) continue;
            max = this.getKeyAtIndex(i);
            isMaxSet = true;
        }
        return max;
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double min() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        double min = 0.0;
        boolean isMinSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                min = 0.0;
                isMinSet = true;
            }
            if (this.getSentinelValues().containsOneKey && !isMinSet) {
                min = 1.0;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMinSet && Double.compare(this.getKeyAtIndex(i), min) >= 0) continue;
            min = this.getKeyAtIndex(i);
            isMinSet = true;
        }
        return min;
    }

    public double minIfEmpty(double defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    public double[] toArray() {
        int size = this.getOuter().size();
        final double[] result = new double[size];
        this.getOuter().forEachKey(new DoubleProcedure(){
            private int index;

            public void value(double each) {
                result[this.index] = each;
                ++this.index;
            }
        });
        return result;
    }

    public boolean contains(double value) {
        return this.getOuter().containsKey(value);
    }

    public boolean containsAll(double ... source) {
        for (double item : source) {
            if (this.getOuter().containsKey(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (this.getOuter().containsKey(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result = function.valueOf(result, 0.0);
            }
            if (this.getSentinelValues().containsOneKey) {
                result = function.valueOf(result, 1.0);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result = function.valueOf(result, this.getKeyAtIndex(i));
        }
        return result;
    }

    public ImmutableDoubleSet toImmutable() {
        return DoubleSets.immutable.withAll((DoubleIterable)this);
    }

    public int size() {
        return this.getOuter().size();
    }

    public boolean isEmpty() {
        return this.getOuter().isEmpty();
    }

    public boolean notEmpty() {
        return this.getOuter().notEmpty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleSet)) {
            return false;
        }
        DoubleSet other = (DoubleSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    public int hashCode() {
        int result = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32);
            }
            if (this.getSentinelValues().containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += (int)(Double.doubleToLongBits(this.getKeyAtIndex(i)) ^ Double.doubleToLongBits(this.getKeyAtIndex(i)) >>> 32);
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(0.0));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!AbstractMutableDoubleKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getKeyAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RichIterable<DoubleIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)DoubleSets.mutable.withAll((DoubleIterable)this));
            } else {
                MutableDoubleIterator iterator = this.doubleIterator();
                while (iterator.hasNext()) {
                    MutableDoubleSet batch = DoubleSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch);
                }
            }
        }
        return result;
    }
}

