/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableBooleanStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableBooleanStack;
import org.eclipse.collections.impl.factory.primitive.BooleanStacks;
import org.eclipse.collections.impl.stack.mutable.primitive.BooleanArrayStack;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableBooleanStackFactoryImpl implements MutableBooleanStackFactory
{
    INSTANCE;


    public MutableBooleanStack empty() {
        return new BooleanArrayStack();
    }

    public MutableBooleanStack of() {
        return this.empty();
    }

    public MutableBooleanStack with() {
        return this.empty();
    }

    public MutableBooleanStack of(boolean ... items) {
        return this.with(items);
    }

    public MutableBooleanStack with(boolean ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return BooleanArrayStack.newStackWith(items);
    }

    public MutableBooleanStack ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    public MutableBooleanStack withAll(BooleanIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return BooleanArrayStack.newStack(items);
    }

    public MutableBooleanStack ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    public MutableBooleanStack withAll(Iterable<Boolean> iterable) {
        MutableBooleanStack stack = BooleanStacks.mutable.empty();
        Iterate.forEach(iterable, arg_0 -> ((MutableBooleanStack)stack).push(arg_0));
        return stack;
    }

    public MutableBooleanStack ofAllReversed(BooleanIterable items) {
        return this.withAllReversed(items);
    }

    public MutableBooleanStack withAllReversed(BooleanIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return BooleanArrayStack.newStackFromTopToBottom(items);
    }
}

