/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.primitive;

import java.util.EmptyStackException;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.stack.primitive.FloatStack;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

public abstract class AbstractFloatStack
implements FloatStack {
    protected abstract FloatArrayList getDelegate();

    protected void checkEmptyStack() {
        if (this.getDelegate().isEmpty()) {
            throw new EmptyStackException();
        }
    }

    public float peek() {
        this.checkEmptyStack();
        return this.getDelegate().getLast();
    }

    public FloatList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new FloatArrayList(0);
        }
        FloatArrayList subList = new FloatArrayList(count);
        int index = this.getDelegate().size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.getDelegate().get(index - i));
        }
        return subList;
    }

    public float peekAt(int index) {
        this.rangeCheck(index);
        return this.getDelegate().get(this.getDelegate().size() - 1 - index);
    }

    protected void rangeCheck(int index) {
        if (index < 0 || index > this.getDelegate().size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.getDelegate().size() - 1));
        }
    }

    protected void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    protected void checkSizeLessThanCount(int count) {
        if (this.getDelegate().size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.getDelegate().size());
        }
    }

    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(this.getDelegate().asReversed().floatIterator());
    }

    public void each(FloatProcedure procedure) {
        this.getDelegate().asReversed().forEach(procedure);
    }

    public int count(FloatPredicate predicate) {
        return this.getDelegate().asReversed().count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return this.getDelegate().asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return this.getDelegate().asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return this.getDelegate().asReversed().noneSatisfy(predicate);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return this.getDelegate().asReversed().detectIfNone(predicate, ifNone);
    }

    public float[] toArray() {
        return this.getDelegate().asReversed().toArray();
    }

    public boolean contains(float value) {
        return this.getDelegate().asReversed().contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.getDelegate().asReversed().containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.getDelegate().asReversed().containsAll(source);
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList((FloatIterable)this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet((FloatIterable)this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag((FloatIterable)this);
    }

    public <V> V injectInto(V injectedValue, ObjectFloatToObjectFunction<? super V, ? extends V> function) {
        return this.getDelegate().toReversed().injectInto(injectedValue, function);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public int size() {
        return this.getDelegate().size();
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof FloatStack)) {
            return false;
        }
        FloatStack stack = (FloatStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Float.compare(this.peekAt(i), stack.peekAt(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyFloatIterable iterable = this.getDelegate().asReversed();
        FloatIterator iterator = iterable.floatIterator();
        while (iterator.hasNext()) {
            float item = iterator.next();
            hashCode = 31 * hashCode + Float.floatToIntBits(item);
        }
        return hashCode;
    }

    public String toString() {
        return this.getDelegate().asReversed().toString();
    }

    public String makeString() {
        return this.getDelegate().asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.getDelegate().asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.getDelegate().asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.getDelegate().asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.getDelegate().asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.getDelegate().asReversed().appendString(appendable, start, separator, end);
    }

    public float getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    public int indexOf(float value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectFloatIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    public void forEachWithIndex(FloatIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public RichIterable<FloatIterable> chunk(int size) {
        return this.getDelegate().asReversed().chunk(size);
    }

    public double sum() {
        return this.getDelegate().sum();
    }

    public float max() {
        return this.getDelegate().max();
    }

    public float min() {
        return this.getDelegate().min();
    }

    public float minIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public float maxIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        return this.getDelegate().average();
    }

    public double median() {
        return this.getDelegate().median();
    }

    public float[] toSortedArray() {
        return this.getDelegate().toSortedArray();
    }
}

