/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.primitive;

import java.io.Serializable;
import net.jcip.annotations.GuardedBy;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;

public class SynchronizedDoubleIterable
implements DoubleIterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    @GuardedBy(value="this.lock")
    private final DoubleIterable iterable;

    protected SynchronizedDoubleIterable(DoubleIterable iterable) {
        this(iterable, null);
    }

    protected SynchronizedDoubleIterable(DoubleIterable iterable, Object newLock) {
        if (iterable == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedDoubleIterable on a null collection");
        }
        this.iterable = iterable;
        this.lock = newLock == null ? this : newLock;
    }

    public static SynchronizedDoubleIterable of(DoubleIterable iterable) {
        return new SynchronizedDoubleIterable(iterable);
    }

    public static SynchronizedDoubleIterable of(DoubleIterable iterable, Object lock) {
        return new SynchronizedDoubleIterable(iterable, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(double value) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(double ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(DoubleIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void each(DoubleProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleIterable select(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleIterable reject(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> RichIterable<V> collect(DoubleToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyDoubleIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double max() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double maxIfEmpty(double defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double min() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double minIfEmpty(double defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.iterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, start, separator, end);
        }
    }

    public DoubleIterator doubleIterator() {
        return this.iterable.doubleIterator();
    }
}

