/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.JGitText;

public class SimpleLruCache<K, V> {
    private Lock lock = new ReentrantLock();
    private Map<K, Entry<K, V>> map = new ConcurrentHashMap<K, Entry<K, V>>();
    private volatile int maximumSize;
    private int purgeSize;
    private volatile long time = 0L;

    private static void checkPurgeFactor(float purgeFactor) {
        if (purgeFactor <= 0.0f || purgeFactor >= 1.0f) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidPurgeFactor, Float.valueOf(purgeFactor)));
        }
    }

    private static int purgeSize(int maxSize, float purgeFactor) {
        return (int)((1.0f - purgeFactor) * (float)maxSize);
    }

    public SimpleLruCache(int maxSize, float purgeFactor) {
        SimpleLruCache.checkPurgeFactor(purgeFactor);
        this.maximumSize = maxSize;
        this.purgeSize = SimpleLruCache.purgeSize(maxSize, purgeFactor);
    }

    public V get(Object key) {
        Entry<K, V> entry = this.map.get(key);
        if (entry != null) {
            ((Entry)entry).lastAccessed = this.tick();
            return (V)((Entry)entry).value;
        }
        return null;
    }

    public V put(@NonNull K key, @NonNull V value) {
        this.map.put(key, new Entry<K, V>(key, value, this.tick()));
        if (this.map.size() > this.maximumSize) {
            this.purge();
        }
        return value;
    }

    private long tick() {
        return ++this.time;
    }

    public int size() {
        return this.map.size();
    }

    public void configure(int maxSize, float purgeFactor) {
        this.lock.lock();
        try {
            SimpleLruCache.checkPurgeFactor(purgeFactor);
            this.maximumSize = maxSize;
            this.purgeSize = SimpleLruCache.purgeSize(maxSize, purgeFactor);
            if (this.map.size() >= this.maximumSize) {
                this.purge();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void purge() {
        if (this.lock.tryLock()) {
            try {
                void var2_5;
                ArrayList<Entry<K, V>> entriesToPurge = new ArrayList<Entry<K, V>>(this.map.values());
                for (Entry entry : entriesToPurge) {
                    entry.copyAccessTime();
                }
                Collections.sort(entriesToPurge, Comparator.comparingLong(o -> -((Entry)o).lastAccessedSorting));
                int n = this.purgeSize;
                while (var2_5 < entriesToPurge.size()) {
                    this.map.remove(((Entry)entriesToPurge.get((int)var2_5)).key);
                    ++var2_5;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class Entry<K, V> {
        private final K key;
        private final V value;
        private volatile long lastAccessed;
        private long lastAccessedSorting;

        Entry(K key, V value, long lastAccessed) {
            this.key = key;
            this.value = value;
            this.lastAccessed = lastAccessed;
        }

        void copyAccessTime() {
            this.lastAccessedSorting = this.lastAccessed;
        }

        public String toString() {
            return "Entry [lastAccessed=" + this.lastAccessed + ", key=" + this.key + ", value=" + this.value + "]";
        }
    }
}

