/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.ignore.FastIgnoreRule;

public class IgnoreNode {
    private final List<FastIgnoreRule> rules;

    public IgnoreNode() {
        this.rules = new ArrayList<FastIgnoreRule>();
    }

    public IgnoreNode(List<FastIgnoreRule> rules) {
        this.rules = rules;
    }

    public void parse(InputStream in) throws IOException {
        String txt;
        BufferedReader br = IgnoreNode.asReader(in);
        while ((txt = br.readLine()) != null) {
            FastIgnoreRule rule;
            if (txt.length() <= 0 || txt.startsWith("#") || txt.equals("/") || (rule = new FastIgnoreRule(txt)).isEmpty()) continue;
            this.rules.add(rule);
        }
    }

    private static BufferedReader asReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public List<FastIgnoreRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public MatchResult isIgnored(String entryPath, boolean isDirectory) {
        Boolean result = this.checkIgnored(entryPath, isDirectory);
        if (result == null) {
            return MatchResult.CHECK_PARENT;
        }
        return result != false ? MatchResult.IGNORED : MatchResult.NOT_IGNORED;
    }

    public Boolean checkIgnored(String entryPath, boolean isDirectory) {
        int i = this.rules.size() - 1;
        while (i > -1) {
            FastIgnoreRule rule = this.rules.get(i);
            if (rule.isMatch(entryPath, isDirectory, true)) {
                return rule.getResult();
            }
            --i;
        }
        return null;
    }

    public String toString() {
        return this.rules.toString();
    }

    public static enum MatchResult {
        NOT_IGNORED,
        IGNORED,
        CHECK_PARENT,
        CHECK_PARENT_NEGATE_FIRST_MATCH;

    }
}

