/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.publisher.FeatureDependenciesAction;
import org.eclipse.tycho.p2.impl.resolver.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.impl.resolver.QueryableCollection;
import org.eclipse.tycho.p2.impl.resolver.ResolverDebugUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyCollector
extends AbstractResolutionStrategy {
    public DependencyCollector(MavenLogger logger) {
        super(logger);
    }

    @Override
    public Collection<IInstallableUnit> resolve(Map<String, String> properties, IProgressMonitor monitor) {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        LinkedHashSet<IStatus> errors = new LinkedHashSet<IStatus>();
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Available IUs:\n" + ResolverDebugUtils.toDebugString(this.availableIUs, false));
            this.logger.debug("Root IUs:\n" + ResolverDebugUtils.toDebugString(this.rootIUs, true));
        }
        result.addAll(this.rootIUs);
        QueryableCollection availableUIsQueryable = new QueryableCollection(this.availableIUs);
        for (IInstallableUnit iu : this.rootIUs) {
            this.collectIncludedIUs((IQueryable<IInstallableUnit>)availableUIsQueryable, result, errors, iu, true, monitor);
        }
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Collected IUs:\n" + ResolverDebugUtils.toDebugString(result, false));
        }
        if (!errors.isEmpty()) {
            MultiStatus status = new MultiStatus("org.eclipse.tycho.p2.impl", 0, errors.toArray(new IStatus[errors.size()]), "Missing dependencies", null);
            throw new RuntimeException(status.toString(), new ProvisionException((IStatus)status));
        }
        return result;
    }

    private void collectIncludedIUs(IQueryable<IInstallableUnit> availableIUs, Set<IInstallableUnit> result, Set<IStatus> errors, IInstallableUnit iu, boolean immediate, IProgressMonitor monitor) {
        for (IRequirement req : iu.getRequirements()) {
            IQueryResult matches = availableIUs.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0])), monitor);
            if (!matches.isEmpty()) {
                IInstallableUnit match = (IInstallableUnit)matches.iterator().next();
                if (!immediate && !this.isIncluded(iu, req, match)) continue;
                result.add(match);
                if (!this.isFeature(match)) continue;
                this.collectIncludedIUs(availableIUs, result, errors, match, false, monitor);
                continue;
            }
            errors.add((IStatus)new Status(4, "org.eclipse.tycho.p2.impl", "Unable to find dependency from " + iu.toString() + " to " + req.toString()));
        }
    }

    private boolean isIncluded(IInstallableUnit iu, IRequirement req, IInstallableUnit match) {
        Set<String> includedIUs = FeatureDependenciesAction.getIncludedUIs(iu);
        if (includedIUs.contains(match.getId())) {
            return true;
        }
        return RequiredCapability.isVersionStrict((IMatchExpression)req.getMatches());
    }

    private boolean isFeature(IInstallableUnit iu) {
        return QueryUtil.isGroup((IInstallableUnit)iu);
    }
}

