/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.mocksocket;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.Executor;

public class MockHttpServer {
    public static HttpsServer createHttps(InetSocketAddress addr, int backlog) throws IOException {
        HttpsServer httpsServer = HttpsServer.create(addr, backlog);
        return new DelegatingHttpsServer(httpsServer);
    }

    public static HttpServer createHttp(InetSocketAddress addr, int backlog) throws IOException {
        HttpServer httpServer = HttpServer.create(addr, backlog);
        return new DelegatingHttpServer(httpServer);
    }

    private static void privilegeBind(HttpServer httpsServer, InetSocketAddress inetSocketAddress, int i) throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                httpsServer.bind(inetSocketAddress, i);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static void privilegeStart(HttpServer httpsServer) {
        AccessController.doPrivileged(() -> {
            httpsServer.start();
            return null;
        });
    }

    private static class DelegatingHttpServer
    extends HttpServer {
        private final HttpServer httpServer;

        private DelegatingHttpServer(HttpServer httpServer) {
            this.httpServer = httpServer;
        }

        @Override
        public void bind(InetSocketAddress inetSocketAddress, int i) throws IOException {
            MockHttpServer.privilegeBind(this.httpServer, inetSocketAddress, i);
        }

        @Override
        public void start() {
            MockHttpServer.privilegeStart(this.httpServer);
        }

        @Override
        public void setExecutor(Executor executor) {
            this.httpServer.setExecutor(executor);
        }

        @Override
        public Executor getExecutor() {
            return this.httpServer.getExecutor();
        }

        @Override
        public void stop(int i) {
            this.httpServer.stop(i);
        }

        @Override
        public HttpContext createContext(String s, HttpHandler httpHandler) {
            return this.httpServer.createContext(s, httpHandler);
        }

        @Override
        public HttpContext createContext(String s) {
            return this.httpServer.createContext(s);
        }

        @Override
        public void removeContext(String s) throws IllegalArgumentException {
            this.httpServer.removeContext(s);
        }

        @Override
        public void removeContext(HttpContext httpContext) {
            this.httpServer.removeContext(httpContext);
        }

        @Override
        public InetSocketAddress getAddress() {
            return this.httpServer.getAddress();
        }
    }

    private static class DelegatingHttpsServer
    extends HttpsServer {
        private final HttpsServer httpsServer;

        private DelegatingHttpsServer(HttpsServer httpsServer) {
            this.httpsServer = httpsServer;
        }

        @Override
        public void setHttpsConfigurator(HttpsConfigurator httpsConfigurator) {
            this.httpsServer.setHttpsConfigurator(httpsConfigurator);
        }

        @Override
        public HttpsConfigurator getHttpsConfigurator() {
            return this.httpsServer.getHttpsConfigurator();
        }

        @Override
        public void bind(InetSocketAddress inetSocketAddress, int i) throws IOException {
            MockHttpServer.privilegeBind(this.httpsServer, inetSocketAddress, i);
        }

        @Override
        public void start() {
            MockHttpServer.privilegeStart(this.httpsServer);
        }

        @Override
        public void setExecutor(Executor executor) {
            this.httpsServer.setExecutor(executor);
        }

        @Override
        public Executor getExecutor() {
            return this.httpsServer.getExecutor();
        }

        @Override
        public void stop(int i) {
            this.httpsServer.stop(i);
        }

        @Override
        public HttpContext createContext(String s, HttpHandler httpHandler) {
            return this.httpsServer.createContext(s, httpHandler);
        }

        @Override
        public HttpContext createContext(String s) {
            return this.httpsServer.createContext(s);
        }

        @Override
        public void removeContext(String s) throws IllegalArgumentException {
            this.httpsServer.removeContext(s);
        }

        @Override
        public void removeContext(HttpContext httpContext) {
            this.httpsServer.removeContext(httpContext);
        }

        @Override
        public InetSocketAddress getAddress() {
            return this.httpsServer.getAddress();
        }
    }
}

