/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.engine;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.IdentityHashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.AssertingIndexSearcher;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.test.ESIntegTestCase;

public final class MockEngineSupport {
    public static final Setting<Double> WRAP_READER_RATIO = Setting.doubleSetting((String)"index.engine.mock.random.wrap_reader_ratio", (double)0.0, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
    public static final Setting<Boolean> DISABLE_FLUSH_ON_CLOSE = Setting.boolSetting((String)"index.mock.disable_flush_on_close", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final Logger logger = LogManager.getLogger(Engine.class);
    private final ShardId shardId;
    private final QueryCache filterCache;
    private final QueryCachingPolicy filterCachingPolicy;
    private final InFlightSearchers inFlightSearchers;
    private final MockContext mockContext;
    private final boolean disableFlushOnClose;

    public boolean isFlushOnCloseDisabled() {
        return this.disableFlushOnClose;
    }

    public MockEngineSupport(EngineConfig config, Class<? extends FilterDirectoryReader> wrapper) {
        boolean wrapReader;
        Settings settings = config.getIndexSettings().getSettings();
        this.shardId = config.getShardId();
        this.filterCache = config.getQueryCache();
        this.filterCachingPolicy = config.getQueryCachingPolicy();
        long seed = (Long)config.getIndexSettings().getValue(ESIntegTestCase.INDEX_TEST_SEED_SETTING);
        Random random = new Random(seed);
        double ratio = (Double)WRAP_READER_RATIO.get(settings);
        boolean bl = wrapReader = random.nextDouble() < ratio;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Using [{}] for shard [{}] seed: [{}] wrapReader: [{}]", (Object)this.getClass().getName(), (Object)this.shardId, (Object)seed, (Object)wrapReader);
        }
        this.mockContext = new MockContext(random, wrapReader, wrapper, settings);
        this.inFlightSearchers = new InFlightSearchers();
        LuceneTestCase.closeAfterSuite((Closeable)this.inFlightSearchers);
        this.disableFlushOnClose = (Boolean)DISABLE_FLUSH_ON_CLOSE.get(settings);
    }

    public CloseAction flushOrClose(CloseAction originalAction) throws IOException {
        if (this.closing.compareAndSet(false, true)) {
            if (this.mockContext.random.nextBoolean()) {
                return CloseAction.FLUSH_AND_CLOSE;
            }
            return CloseAction.CLOSE;
        }
        return originalAction;
    }

    public AssertingIndexSearcher newSearcher(Engine.Searcher searcher) throws EngineException {
        IndexReader reader;
        IndexReader wrappedReader = reader = searcher.reader();
        assert (reader != null);
        if (reader instanceof DirectoryReader && this.mockContext.wrapReader) {
            wrappedReader = this.wrapReader((DirectoryReader)reader);
        }
        AssertingIndexSearcher assertingIndexSearcher = new AssertingIndexSearcher(this.mockContext.random, wrappedReader);
        assertingIndexSearcher.setSimilarity(searcher.searcher().getSimilarity(true));
        assertingIndexSearcher.setQueryCache(this.filterCache);
        assertingIndexSearcher.setQueryCachingPolicy(this.filterCachingPolicy);
        return assertingIndexSearcher;
    }

    private DirectoryReader wrapReader(DirectoryReader reader) {
        try {
            Constructor<?>[] constructors = this.mockContext.wrapper.getConstructors();
            Constructor<?> nonRandom = null;
            for (Constructor<?> constructor : constructors) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length <= 0 || parameterTypes[0] != DirectoryReader.class) continue;
                if (parameterTypes.length == 1) {
                    nonRandom = constructor;
                    continue;
                }
                if (parameterTypes.length != 2 || parameterTypes[1] != Settings.class) continue;
                return (DirectoryReader)constructor.newInstance(reader, this.mockContext.indexSettings);
            }
            if (nonRandom != null) {
                return (DirectoryReader)nonRandom.newInstance(reader);
            }
        }
        catch (Exception e) {
            throw new ElasticsearchException("Can not wrap reader", (Throwable)e, new Object[0]);
        }
        return reader;
    }

    public Engine.Searcher wrapSearcher(Engine.Searcher engineSearcher) {
        AssertingIndexSearcher assertingIndexSearcher = this.newSearcher(engineSearcher);
        assertingIndexSearcher.setSimilarity(engineSearcher.searcher().getSimilarity(true));
        SearcherCloseable closeable = new SearcherCloseable(engineSearcher, this.logger, this.inFlightSearchers);
        return new Engine.Searcher(engineSearcher.source(), (IndexSearcher)assertingIndexSearcher, (Closeable)closeable);
    }

    private static final class SearcherCloseable
    implements Closeable {
        private final Engine.Searcher wrappedSearcher;
        private final InFlightSearchers inFlightSearchers;
        private RuntimeException firstReleaseStack;
        private final Object lock = new Object();
        private final int initialRefCount;
        private final Logger logger;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        SearcherCloseable(Engine.Searcher wrappedSearcher, Logger logger, InFlightSearchers inFlightSearchers) {
            this.wrappedSearcher = wrappedSearcher;
            this.logger = logger;
            this.initialRefCount = wrappedSearcher.reader().getRefCount();
            this.inFlightSearchers = inFlightSearchers;
            assert (this.initialRefCount > 0) : "IndexReader#getRefCount() was [" + this.initialRefCount + "] expected a value > [0] - reader is already closed";
            inFlightSearchers.add(this, wrappedSearcher.source());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed.compareAndSet(false, true)) {
                    this.inFlightSearchers.remove(this);
                    this.firstReleaseStack = new RuntimeException();
                    int refCount = this.wrappedSearcher.reader().getRefCount();
                    assert (refCount > 0) : "IndexReader#getRefCount() was [" + refCount + "] expected a value > [0] - reader is already  closed. Initial refCount was: [" + this.initialRefCount + "]";
                    try {
                        this.wrappedSearcher.close();
                    }
                    catch (RuntimeException ex) {
                        this.logger.debug("Failed to release searcher", (Throwable)ex);
                        throw ex;
                    }
                } else {
                    AssertionError error = new AssertionError((Object)("Released Searcher more than once, source [" + this.wrappedSearcher.source() + "]"));
                    ((Throwable)((Object)error)).initCause(this.firstReleaseStack);
                    throw error;
                }
            }
        }
    }

    private static final class InFlightSearchers
    implements Closeable {
        private final IdentityHashMap<Object, RuntimeException> openSearchers = new IdentityHashMap();

        private InFlightSearchers() {
        }

        @Override
        public synchronized void close() {
            if (!this.openSearchers.isEmpty()) {
                AssertionError error = new AssertionError((Object)"Unreleased searchers found");
                for (RuntimeException ex : this.openSearchers.values()) {
                    ((Throwable)((Object)error)).addSuppressed(ex);
                }
                throw error;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Object key, String source) {
            RuntimeException ex = new RuntimeException("Unreleased Searcher, source [" + source + "]");
            InFlightSearchers inFlightSearchers = this;
            synchronized (inFlightSearchers) {
                this.openSearchers.put(key, ex);
            }
        }

        synchronized void remove(Object key) {
            this.openSearchers.remove(key);
        }
    }

    public static abstract class DirectoryReaderWrapper
    extends FilterDirectoryReader {
        protected final FilterDirectoryReader.SubReaderWrapper subReaderWrapper;

        public DirectoryReaderWrapper(DirectoryReader in, FilterDirectoryReader.SubReaderWrapper subReaderWrapper) throws IOException {
            super(in, subReaderWrapper);
            this.subReaderWrapper = subReaderWrapper;
        }
    }

    static enum CloseAction {
        FLUSH_AND_CLOSE,
        CLOSE;

    }

    public static class MockContext {
        private final Random random;
        private final boolean wrapReader;
        private final Class<? extends FilterDirectoryReader> wrapper;
        private final Settings indexSettings;

        public MockContext(Random random, boolean wrapReader, Class<? extends FilterDirectoryReader> wrapper, Settings indexSettings) {
            this.random = random;
            this.wrapReader = wrapReader;
            this.wrapper = wrapper;
            this.indexSettings = indexSettings;
        }
    }
}

