/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.hamcrest;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class CollectionMatchers {

    public static class ImmutableOpenMapHasAllKeysMatcher
    extends TypeSafeMatcher<ImmutableOpenMap> {
        private final List<String> keys;
        private String missingKey;

        public ImmutableOpenMapHasAllKeysMatcher(String ... keys) {
            this.keys = Arrays.asList(keys);
        }

        protected boolean matchesSafely(ImmutableOpenMap item) {
            for (String key : this.keys) {
                if (item.containsKey((Object)key)) continue;
                this.missingKey = key;
                return false;
            }
            return true;
        }

        public void describeMismatchSafely(ImmutableOpenMap map, Description mismatchDescription) {
            if (map.size() == 0) {
                mismatchDescription.appendText("was empty");
            } else {
                mismatchDescription.appendText("was ").appendValue((Object)map.keys());
            }
        }

        public void describeTo(Description description) {
            description.appendText("ImmutableOpenMap should contain all keys ").appendValue(this.keys).appendText(", but key [").appendValue((Object)this.missingKey).appendText("] is missing");
        }
    }

    public static class ImmutableOpenMapHasKeyMatcher
    extends TypeSafeMatcher<ImmutableOpenMap> {
        private final String key;

        public ImmutableOpenMapHasKeyMatcher(String key) {
            this.key = key;
        }

        protected boolean matchesSafely(ImmutableOpenMap item) {
            return item.containsKey((Object)this.key);
        }

        public void describeMismatchSafely(ImmutableOpenMap map, Description mismatchDescription) {
            if (map.size() == 0) {
                mismatchDescription.appendText("was empty");
            } else {
                mismatchDescription.appendText(" was ").appendValue((Object)map);
            }
        }

        public void describeTo(Description description) {
            description.appendText("ImmutableOpenMap should contain key " + this.key);
        }
    }
}

