/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.NodeSelector;

public class ApiCallSection {
    private final String api;
    private final Map<String, String> params = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final List<Map<String, Object>> bodies = new ArrayList<Map<String, Object>>();
    private NodeSelector nodeSelector = NodeSelector.ANY;

    public ApiCallSection(String api) {
        this.api = api;
    }

    public String getApi() {
        return this.api;
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public void addParam(String key, String value) {
        String existingValue = this.params.get(key);
        if (existingValue != null) {
            value = existingValue + "," + value;
        }
        this.params.put(key, value);
    }

    public void addHeaders(Map<String, String> otherHeaders) {
        this.headers.putAll(otherHeaders);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public List<Map<String, Object>> getBodies() {
        return Collections.unmodifiableList(this.bodies);
    }

    public void addBody(Map<String, Object> body) {
        this.bodies.add(body);
    }

    public boolean hasBody() {
        return this.bodies.size() > 0;
    }

    public NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }
}

