/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.elasticsearch.test.rest.yaml.section.ContainsAssertion;
import org.elasticsearch.test.rest.yaml.section.DoSection;
import org.elasticsearch.test.rest.yaml.section.GreaterThanAssertion;
import org.elasticsearch.test.rest.yaml.section.GreaterThanEqualToAssertion;
import org.elasticsearch.test.rest.yaml.section.IsFalseAssertion;
import org.elasticsearch.test.rest.yaml.section.IsTrueAssertion;
import org.elasticsearch.test.rest.yaml.section.LengthAssertion;
import org.elasticsearch.test.rest.yaml.section.LessThanAssertion;
import org.elasticsearch.test.rest.yaml.section.LessThanOrEqualToAssertion;
import org.elasticsearch.test.rest.yaml.section.MatchAssertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.test.rest.yaml.section.SetSection;

public interface ExecutableSection {
    public static final List<NamedXContentRegistry.Entry> DEFAULT_EXECUTABLE_CONTEXTS = Collections.unmodifiableList(Arrays.asList(new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("do", new String[0]), DoSection::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("set", new String[0]), SetSection::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("match", new String[0]), MatchAssertion::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("is_true", new String[0]), IsTrueAssertion::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("is_false", new String[0]), IsFalseAssertion::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("gt", new String[0]), GreaterThanAssertion::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("gte", new String[0]), GreaterThanEqualToAssertion::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("lt", new String[0]), LessThanAssertion::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("lte", new String[0]), LessThanOrEqualToAssertion::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("contains", new String[0]), ContainsAssertion::parse), new NamedXContentRegistry.Entry(ExecutableSection.class, new ParseField("length", new String[0]), LengthAssertion::parse)));
    public static final NamedXContentRegistry XCONTENT_REGISTRY = new NamedXContentRegistry(DEFAULT_EXECUTABLE_CONTEXTS);

    public static ExecutableSection parse(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        String section = parser.currentName();
        XContentLocation location = parser.getTokenLocation();
        try {
            ExecutableSection executableSection = (ExecutableSection)parser.namedObject(ExecutableSection.class, section, null);
            parser.nextToken();
            return executableSection;
        }
        catch (Exception e) {
            throw new IOException("Error parsing section starting at [" + location + "]", e);
        }
    }

    public XContentLocation getLocation();

    public void execute(ClientYamlTestExecutionContext var1) throws IOException;
}

