/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.resources;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.ff4j.FF4j;
import org.ff4j.core.FlippingExecutionContext;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.utils.FeatureJsonMarshaller;
import org.ff4j.web.api.FF4jWebConstants;
import org.ff4j.web.resources.FeatureStoreResource;
import org.ff4j.web.resources.MonitoringResource;

@Path(value="/ff4j")
@Produces(value={"application/json"})
public class FF4jResource
implements FF4jWebConstants {
    @Context
    private FF4j ff4j = null;
    @Context
    private UriInfo uriInfo;
    @Context
    private Request request;

    @Path(value="store")
    public FeatureStoreResource getFeaturesResource() {
        return new FeatureStoreResource(this.uriInfo, this.request, this.ff4j.getStore());
    }

    @Path(value="monitoring")
    public MonitoringResource getMonitoringResource() {
        return new MonitoringResource(this.uriInfo, this.request);
    }

    @GET
    public Response getStatus() {
        return Response.ok((Object)this.ff4j.toString()).build();
    }

    @POST
    @Path(value="flip")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response check(MultivaluedMap<String, String> formParams) {
        if (!formParams.containsKey((Object)"uid")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"uid is a required POST parameter").build();
        }
        String uid = (String)formParams.getFirst((Object)"uid");
        if (!this.ff4j.getStore().exist(uid)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new FeatureNotFoundException(uid).getMessage()).build();
        }
        boolean flipped = false;
        if (formParams.containsKey((Object)"flipstrategy")) {
            FlippingStrategy fs = FeatureJsonMarshaller.parseFlipStrategy((String)uid, (String)((String)formParams.getFirst((Object)"flipstrategy")));
            FlippingExecutionContext fec = new FlippingExecutionContext();
            for (String key : formParams.keySet()) {
                if ("flipstrategy".equals(key) || "uid".equals(key)) continue;
                fec.putString(key, (String)formParams.getFirst((Object)key));
            }
            flipped = this.ff4j.checkOveridingStrategy(uid, fs, fec);
        } else {
            flipped = this.ff4j.check(uid);
        }
        return Response.ok((Object)String.valueOf(flipped)).build();
    }

    public FF4j getFf4j() {
        return this.ff4j;
    }

    public void setFf4j(FF4j ff4j) {
        this.ff4j = ff4j;
    }
}

