/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.resources;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.utils.FeatureJsonMarshaller;
import org.ff4j.web.api.FF4jWebConstants;

public class GroupResource
implements FF4jWebConstants {
    @Context
    private UriInfo uriInfo;
    @Context
    private Request request;
    private FeatureStore store = null;
    private String groupName = null;

    public GroupResource() {
    }

    public GroupResource(UriInfo uriInfo, Request request, FeatureStore store, String group) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.store = store;
        this.groupName = group;
    }

    @GET
    @Produces(value={"application/json"})
    public Response read() {
        Feature[] storeContent = this.getStore().readGroup(this.groupName).values().toArray(new Feature[0]);
        String storeAsJson = FeatureJsonMarshaller.marshallFeatureArray((Feature[])storeContent);
        return Response.ok((Object)storeAsJson).build();
    }

    @POST
    @Path(value="enable")
    public Response operationEnable() {
        this.getStore().enableGroup(this.groupName);
        return Response.noContent().build();
    }

    @POST
    @Path(value="disable")
    public Response operationDisableGroup() {
        this.getStore().disableGroup(this.groupName);
        return Response.noContent().build();
    }

    public FeatureStore getStore() {
        return this.store;
    }

    public String getGroupName() {
        return this.groupName;
    }
}

