/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ff4j.FF4j;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.repository.EventRepository;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.property.Property;
import org.ff4j.property.PropertyBigDecimal;
import org.ff4j.property.PropertyBigInteger;
import org.ff4j.property.PropertyBoolean;
import org.ff4j.property.PropertyByte;
import org.ff4j.property.PropertyDouble;
import org.ff4j.property.PropertyFloat;
import org.ff4j.property.PropertyInt;
import org.ff4j.property.PropertyLogLevel;
import org.ff4j.property.PropertyLong;
import org.ff4j.property.PropertyShort;
import org.ff4j.property.PropertyString;
import org.ff4j.utils.Util;
import org.ff4j.web.embedded.ConsoleConstants;

public final class ConsoleRenderer {
    private static String htmlTemplate = null;
    private static String htmlTemplateMonitoring = null;
    private static String cssContent = null;
    private static String jsContent = null;
    static final String TABLE_FEATURES_FOOTER = "</tbody></table></form></fieldset>";
    static final String END_OF_LINE = "\r\n";
    static final String FF4J_VERSION = ConsoleRenderer.class.getPackage().getImplementationVersion();
    static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss");
    private static Map<String, String> uxTypes = new HashMap<String, String>();

    private ConsoleRenderer() {
    }

    public static void renderPage(FF4j ff4j, HttpServletRequest req, HttpServletResponse res, String msg, String msgType) throws IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        String htmlContent = ConsoleRenderer.renderTemplate(req);
        htmlContent = htmlContent.replaceAll("\\{ALERT\\}", ConsoleRenderer.renderMessageBox(msg, msgType));
        try {
            htmlContent = htmlContent.replaceAll("\\{FEATURE_ROWS\\}", ConsoleRenderer.renderFeatureRows(ff4j, req));
        }
        catch (IllegalArgumentException ieo) {
            htmlContent = htmlContent.replaceAll("\\{FEATURE_ROWS\\}", "Cannot render Features please check names (no $) '" + ieo.getMessage() + "'");
        }
        try {
            htmlContent = htmlContent.replaceAll("\\{PROPERTIES_ROWS\\}", ConsoleRenderer.renderPropertiesRows(ff4j, req));
        }
        catch (IllegalArgumentException ieo) {
            htmlContent = htmlContent.replaceAll("\\{PROPERTIES_ROWS\\}", "Cannot render propertie please check names (no $) '" + ieo.getMessage() + "'");
        }
        String groups = ConsoleRenderer.renderGroupList(ff4j, "modalEdit");
        htmlContent = htmlContent.replaceAll("\\{FEATURE_GRPS_EDIT\\}", groups);
        groups = groups.replaceAll("modalEdit", "modalCreate");
        htmlContent = htmlContent.replaceAll("\\{FEATURE_GRPS_CREATE\\}", groups);
        groups = groups.replaceAll("modalCreate", "modalToggle");
        htmlContent = htmlContent.replaceAll("\\{FEATURE_GRPS_TOGGLE\\}", groups);
        String permissions = ConsoleRenderer.renderPermissionList(ff4j);
        htmlContent = htmlContent.replaceAll("\\{PERMISSIONS\\}", permissions);
        out.println(htmlContent);
    }

    public static void renderPageMonitoring(FF4j ff4j, HttpServletRequest req, HttpServletResponse res, String msg, String msgType) throws IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        String htmlContent = ConsoleRenderer.renderTemplateMonitoring(req);
        htmlContent = htmlContent.replaceAll("\\{ALERT\\}", ConsoleRenderer.renderMessageBox(msg, msgType));
        htmlContent = htmlContent.replaceAll("\\{AUDIT_ROWS\\}", ConsoleRenderer.renderAuditRows(ff4j, req));
        out.println(htmlContent);
    }

    public static String msg(String featureName, String operationId) {
        return String.format("Feature <b>%s</b> has been successfully %s", featureName, operationId);
    }

    public static String renderMsgProperty(String featureName, String operationId) {
        return String.format("Property <b>%s</b> has been successfully %s", featureName, operationId);
    }

    public static String renderMsgGroup(String groupName, String operationId) {
        return String.format("Group <b>%s</b> has been successfully %s", groupName, operationId);
    }

    public static boolean renderResources(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String resources = req.getParameter("rsc");
        if (resources != null && !resources.isEmpty()) {
            if ("css".equalsIgnoreCase(resources)) {
                res.setContentType("text/css");
                res.getWriter().println(ConsoleRenderer.getCSS());
                return true;
            }
            if ("js".equalsIgnoreCase(resources)) {
                res.setContentType("application/javascript");
                res.getWriter().println(ConsoleRenderer.getJS());
                return true;
            }
        }
        return false;
    }

    public static String renderMessageBox(String message, String type) {
        StringBuilder sb = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            sb.append("<div class=\"alert alert-" + type + "\" >");
            sb.append("<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>");
            sb.append("<span style=\"font-style:normal;color:#696969;\">");
            sb.append(message);
            sb.append("</span>");
            sb.append("</div>");
        }
        return sb.toString();
    }

    private static final String renderTemplate(HttpServletRequest req) {
        if (htmlTemplate == null || htmlTemplate.isEmpty()) {
            String ctx = req.getContextPath() + req.getServletPath() + "";
            htmlTemplate = ConsoleRenderer.loadFileAsString("ff4j-template.html");
            htmlTemplate = htmlTemplate.replaceAll("\\{SERVLET_CONTEXT\\}", ctx);
            htmlTemplate = htmlTemplate.replaceAll("\\{VERSION\\}", FF4J_VERSION);
        }
        return htmlTemplate;
    }

    private static final String renderTemplateMonitoring(HttpServletRequest req) {
        if (htmlTemplateMonitoring == null || htmlTemplateMonitoring.isEmpty()) {
            String ctx = req.getContextPath() + req.getServletPath() + "";
            htmlTemplateMonitoring = ConsoleRenderer.loadFileAsString("ff4j-monitoring.html");
            htmlTemplateMonitoring = htmlTemplateMonitoring.replaceAll("\\{SERVLET_CONTEXT\\}", ctx);
            htmlTemplateMonitoring = htmlTemplateMonitoring.replaceAll("\\{VERSION\\}", FF4J_VERSION);
        }
        return htmlTemplateMonitoring;
    }

    public static String renderValue(String source, int column) {
        StringBuilder sb = new StringBuilder();
        source = source.replaceAll("\\\\", "/");
        source = source.replaceAll("\\$", "&dollar;");
        while (source.length() > column) {
            sb.append(source.substring(0, column));
            sb.append("\r\n<br>");
            source = source.substring(column);
        }
        sb.append(source);
        return sb.toString();
    }

    private static final String renderPropertiesRows(FF4j ff4j, HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        Map mapOfProperties = ff4j.getProperties();
        for (Map.Entry uid : mapOfProperties.entrySet()) {
            Property currentProperty = (Property)uid.getValue();
            sb.append("<tr>\r\n");
            sb.append("<td><a class=\"ff4j-properties\" ");
            if (null != currentProperty.getDescription()) {
                sb.append(" tooltip=\"");
                sb.append(currentProperty.getDescription());
                sb.append("\"");
            }
            sb.append(">");
            sb.append(ConsoleRenderer.renderValue(currentProperty.getName(), 50));
            sb.append("</a>");
            sb.append("</td><td>");
            if (null != currentProperty.asString()) {
                sb.append(ConsoleRenderer.renderValue(currentProperty.asString(), 60));
            } else {
                sb.append("--");
            }
            sb.append("</td><td>");
            if (uxTypes.containsValue(currentProperty.getType())) {
                sb.append((String)Util.getFirstKeyByValue(uxTypes, (Object)currentProperty.getType()));
            } else {
                sb.append(currentProperty.getType());
            }
            sb.append("</td><td>");
            if (null != currentProperty.getFixedValues()) {
                for (Object o : currentProperty.getFixedValues()) {
                    sb.append("<li>" + o.toString());
                }
            } else {
                sb.append("--");
            }
            sb.append("</td><td style=\"width:5%;text-align:center\">");
            sb.append("<a data-toggle=\"modal\" href=\"#modalEditProperty\" data-pname=\"" + currentProperty.getName() + "\" ");
            sb.append(" style=\"width:6px;\" class=\"open-EditPropertyDialog btn\">");
            sb.append("<i class=\"icon-pencil\" style=\"margin-left:-5px;\"></i></a>");
            sb.append("</td><td style=\"width:5%;text-align:center\">");
            sb.append("<a href=\"");
            sb.append(req.getContextPath());
            sb.append(req.getServletPath());
            sb.append("?op=deleteProperty&uid=" + currentProperty.getName());
            sb.append("\" style=\"width:6px;\" class=\"btn\">");
            sb.append("<i class=\"icon-trash\" style=\"margin-left:-5px;\"></i>");
            sb.append("</a>");
            sb.append("</td></tr>");
        }
        return sb.toString();
    }

    private static final String renderAuditRows(FF4j ff4j, HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        EventRepository er = ff4j.getEventRepository();
        EventQueryDefinition query = new EventQueryDefinition();
        for (Event event : er.searchFeatureUsageEvents(query)) {
            sb.append("<tr>\r\n");
            sb.append("<td>" + SDF.format(new Date(event.getTimestamp())) + "</td>");
            sb.append("<td>" + event.getType() + "</td>");
            sb.append("<td>" + event.getName() + "</td>");
            sb.append("<td>" + event.getAction() + "</td>");
            sb.append("</tr>");
        }
        return sb.toString();
    }

    private static final String renderFeatureRows(FF4j ff4j, HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        Map mapOfFeatures = ff4j.getFeatures();
        for (Map.Entry uid : mapOfFeatures.entrySet()) {
            Feature currentFeature = (Feature)uid.getValue();
            sb.append("<tr>\r\n");
            sb.append("<td><a class=\"ff4j-tooltip\" ");
            if (null != currentFeature.getDescription()) {
                sb.append(" tooltip=\"");
                sb.append(currentFeature.getDescription());
                sb.append("\"");
            }
            sb.append(">");
            sb.append(currentFeature.getUid());
            sb.append("</a>");
            sb.append("</td><td>");
            if (null != currentFeature.getGroup()) {
                sb.append(currentFeature.getGroup());
            } else {
                sb.append("--");
            }
            sb.append("</td><td>");
            Set permissions = currentFeature.getPermissions();
            if (null != permissions && !permissions.isEmpty()) {
                boolean first = true;
                for (String string : permissions) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(string);
                    first = false;
                }
            } else {
                sb.append("--");
            }
            sb.append("</td><td style=\"word-break: break-all;\">");
            FlippingStrategy fs = currentFeature.getFlippingStrategy();
            if (null != fs) {
                sb.append(ConsoleRenderer.renderValue(fs.getClass().getName(), 50));
                if (fs.getInitParams() != null) {
                    for (Map.Entry entry : fs.getInitParams().entrySet()) {
                        sb.append("<li>" + ConsoleRenderer.renderValue((String)entry.getKey() + " =  " + (String)entry.getValue(), 40));
                    }
                }
            } else {
                sb.append("--");
            }
            sb.append("</td><td style=\"width:8%;text-align:center\">");
            sb.append("<label class=\"switch switch-green\">");
            sb.append("<input id=\"" + currentFeature.getUid() + "\" type=\"checkbox\" class=\"switch-input\"");
            sb.append(" onclick=\"javascript:toggle(this)\" ");
            if (currentFeature.isEnable()) {
                sb.append(" checked");
            }
            sb.append(">");
            sb.append("<span class=\"switch-label\" data-on=\"On\" data-off=\"Off\"></span>");
            sb.append("<span class=\"switch-handle\"></span>");
            sb.append("</label>");
            sb.append("</td><td style=\"width:5%;text-align:center\">");
            sb.append("<a data-toggle=\"modal\" href=\"#modalEdit\" data-id=\"" + currentFeature.getUid() + "\" ");
            sb.append(" data-desc=\"" + currentFeature.getDescription() + "\"");
            sb.append(" data-group=\"" + currentFeature.getGroup() + "\"");
            sb.append(" data-strategy=\"");
            if (null != currentFeature.getFlippingStrategy()) {
                sb.append(currentFeature.getFlippingStrategy().getClass().getName());
            }
            sb.append("\" data-stratparams=\"");
            if (null != currentFeature.getFlippingStrategy()) {
                sb.append(currentFeature.getFlippingStrategy().getInitParams());
            }
            sb.append("\" data-permissions=\"");
            if (null != currentFeature.getPermissions() && !currentFeature.getPermissions().isEmpty()) {
                sb.append(currentFeature.getPermissions());
            }
            sb.append("\" style=\"width:6px;\" class=\"open-EditFlipDialog btn\">");
            sb.append("<i class=\"icon-pencil\" style=\"margin-left:-5px;\"></i></a>");
            sb.append("</td><td style=\"width:5%;text-align:center\">");
            sb.append("<a href=\"");
            sb.append(req.getContextPath());
            sb.append(req.getServletPath());
            sb.append("?op=delete&uid=" + (String)uid.getKey());
            sb.append("\" style=\"width:6px;\" class=\"btn\">");
            sb.append("<i class=\"icon-trash\" style=\"margin-left:-5px;\"></i>");
            sb.append("</a>");
            sb.append("</td></tr>");
        }
        return sb.toString();
    }

    private static String renderGroupList(FF4j ff4j, String modalId) {
        StringBuilder sb = new StringBuilder();
        if (null != ff4j.getFeatureStore().readAllGroups()) {
            for (String group : ff4j.getFeatureStore().readAllGroups()) {
                sb.append("<li><a href=\"#\" onclick=\"\\$('\\#" + modalId + " \\#groupName').val('");
                sb.append(group);
                sb.append("');\">");
                sb.append(group);
                sb.append("</a></li>");
            }
        }
        return sb.toString();
    }

    private static String renderPermissionList(FF4j ff4j) {
        StringBuilder sb = new StringBuilder("<br/>");
        if (null != ff4j.getAuthorizationsManager()) {
            for (String permission : ff4j.getAuthorizationsManager().listAllPermissions()) {
                sb.append("\r\n<br/>&nbsp;&nbsp;&nbsp;<input type=\"checkbox\" ");
                sb.append(" name=\"perm-check-" + permission + "\"");
                sb.append(" id=\"perm-check-" + permission + "\" >&nbsp;");
                sb.append(permission);
            }
        }
        return sb.toString();
    }

    private static final String getCSS() {
        if (null == cssContent) {
            cssContent = ConsoleRenderer.loadFileAsString("ff4j-embedded.css");
        }
        return cssContent;
    }

    private static final String getJS() {
        if (null == jsContent) {
            jsContent = ConsoleRenderer.loadFileAsString("ff4j-embedded.js");
        }
        return jsContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadFileAsString(String fileName) {
        InputStream in = ConsoleRenderer.class.getClassLoader().getResourceAsStream(fileName);
        if (in == null) {
            throw new IllegalArgumentException("Cannot load file " + fileName + " from classpath");
        }
        Scanner currentScan = null;
        StringBuilder strBuilder = new StringBuilder();
        try {
            currentScan = new Scanner(in, "UTF-8");
            while (currentScan.hasNextLine()) {
                strBuilder.append(currentScan.nextLine());
                strBuilder.append(ConsoleConstants.NEW_LINE);
            }
        }
        finally {
            if (currentScan != null) {
                currentScan.close();
            }
        }
        return strBuilder.toString();
    }

    static {
        uxTypes.put(Byte.class.getSimpleName(), PropertyByte.class.getName());
        uxTypes.put(Short.class.getSimpleName(), PropertyShort.class.getName());
        uxTypes.put(Integer.class.getSimpleName(), PropertyInt.class.getName());
        uxTypes.put(Long.class.getSimpleName(), PropertyLong.class.getName());
        uxTypes.put(Double.class.getSimpleName(), PropertyDouble.class.getName());
        uxTypes.put(Boolean.class.getSimpleName(), PropertyBoolean.class.getName());
        uxTypes.put(Float.class.getSimpleName(), PropertyFloat.class.getName());
        uxTypes.put(BigInteger.class.getSimpleName(), PropertyBigInteger.class.getName());
        uxTypes.put(BigDecimal.class.getSimpleName(), PropertyBigDecimal.class.getName());
        uxTypes.put("LogLevel", PropertyLogLevel.class.getName());
        uxTypes.put(String.class.getSimpleName(), PropertyString.class.getName());
    }
}

