/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.utils;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.ff4j.web.bean.WebConstants;

public class FileUtils {
    private static final int BUFFER_SIZE = 4096;

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFileAsString(String fileName) throws FileNotFoundException {
        InputStream in = FileUtils.getResourceAsStream(fileName);
        if (in == null) {
            return null;
        }
        Scanner currentScan = null;
        StringBuilder strBuilder = new StringBuilder();
        try {
            currentScan = new Scanner(in, "UTF-8");
            while (currentScan.hasNextLine()) {
                strBuilder.append(currentScan.nextLine());
                strBuilder.append(WebConstants.NEW_LINE);
            }
        }
        finally {
            if (currentScan != null) {
                currentScan.close();
            }
        }
        return strBuilder.toString();
    }

    private static InputStream getResourceAsStream(String fileName) throws FileNotFoundException {
        InputStream is = FileUtils.class.getResourceAsStream(fileName);
        if (is == null) {
            is = FileUtils.class.getClassLoader().getResourceAsStream(fileName);
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        }
        if (is == null) {
            throw new FileNotFoundException("Cannot load file " + fileName + " please check");
        }
        return is;
    }

    public static final String loadFileAsStringWithBuffer(String fileName) throws IOException {
        InputStream in = FileUtils.getResourceAsStream(fileName);
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        int n = 0;
        while (n != -1) {
            out.append(new String(b, 0, n));
            n = in.read(b);
        }
        return out.toString();
    }

    public static String loadAndResizeImageAsBase64(String fileName) {
        return DatatypeConverter.printBase64Binary((byte[])FileUtils.loadAndResizeImageAsByteArray(fileName));
    }

    public static byte[] loadAndResizeImageAsByteArray(String fileName) {
        ByteArrayOutputStream baos = FileUtils.loadAndResizeImage(fileName);
        return baos != null ? baos.toByteArray() : null;
    }

    public static ByteArrayOutputStream loadAndResizeImage(String fileName) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            InputStream is = FileUtils.getResourceAsStream(fileName);
            BufferedImage image = ImageIO.read(is);
            BufferedImage resizedImage = new BufferedImage(130, 180, image.getType());
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(image, 0, 0, 130, 180, null);
            g.dispose();
            ImageIO.write((RenderedImage)resizedImage, FileUtils.getFileExtension(fileName), bos);
            ByteArrayOutputStream byteArrayOutputStream = bos;
            return byteArrayOutputStream;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Invalid image the file cannot be load", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot convert image to base64", e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static ByteArrayOutputStream loadFileAsOutputStream(String fileName) throws FileNotFoundException {
        InputStream is = FileUtils.getResourceAsStream(fileName);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] buf = new byte[8192];
            int c = 0;
            while ((c = is.read(buf, 0, buf.length)) > 0) {
                bos.write(buf, 0, c);
                bos.flush();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot convert image to base64", e);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bos;
    }

    public static byte[] loadFileAsByteArray(String fileName) throws FileNotFoundException {
        ByteArrayOutputStream baos = FileUtils.loadFileAsOutputStream(fileName);
        return baos != null ? baos.toByteArray() : null;
    }

    public static String getFileExtension(String filepath) {
        int lastIndex = filepath.lastIndexOf(".");
        return lastIndex == -1 ? null : filepath.substring(lastIndex + 1, filepath.length());
    }
}

