/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client;

import com.damnhandy.uri.template.MalformedUriTemplateException;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.activation.DataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.gedcomx.Gedcomx;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;
import org.gedcomx.records.Collection;
import org.gedcomx.rs.client.CollectionsState;
import org.gedcomx.rs.client.GedcomxApplicationException;
import org.gedcomx.rs.client.GedcomxApplicationState;
import org.gedcomx.rs.client.PersonSearchResultsState;
import org.gedcomx.rs.client.PersonState;
import org.gedcomx.rs.client.PersonsState;
import org.gedcomx.rs.client.RecordState;
import org.gedcomx.rs.client.RecordsState;
import org.gedcomx.rs.client.RelationshipState;
import org.gedcomx.rs.client.RelationshipsState;
import org.gedcomx.rs.client.SourceDescriptionState;
import org.gedcomx.rs.client.SourceDescriptionsState;
import org.gedcomx.rs.client.StateFactory;
import org.gedcomx.rs.client.StateTransitionOption;
import org.gedcomx.rs.client.util.PersonSearchQueryBuilder;
import org.gedcomx.source.SourceCitation;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.types.RelationshipType;

public class CollectionState
extends GedcomxApplicationState<Gedcomx> {
    public CollectionState(java.net.URI uri) {
        this(uri, new StateFactory());
    }

    private CollectionState(java.net.URI uri, StateFactory stateFactory) {
        this(uri, stateFactory.loadDefaultClient(), stateFactory);
    }

    private CollectionState(java.net.URI uri, Client client, StateFactory stateFactory) {
        this(((ClientRequest.Builder)ClientRequest.create().accept(new String[]{"application/x-gedcomx-v1+json"})).build(uri, "GET"), client, stateFactory);
    }

    private CollectionState(ClientRequest request, Client client, StateFactory stateFactory) {
        this(request, client.handle(request), null, stateFactory);
    }

    protected CollectionState(ClientRequest request, ClientResponse response, String accessToken, StateFactory stateFactory) {
        super(request, response, accessToken, stateFactory);
    }

    @Override
    protected CollectionState clone(ClientRequest request, ClientResponse response) {
        return new CollectionState(request, response, this.accessToken, this.stateFactory);
    }

    @Override
    protected Gedcomx loadEntity(ClientResponse response) {
        return (Gedcomx)response.getEntity(Gedcomx.class);
    }

    @Override
    public CollectionState ifSuccessful() {
        return (CollectionState)super.ifSuccessful();
    }

    @Override
    protected SupportsLinks getMainDataElement() {
        Collection collection = this.getCollection();
        return collection == null ? this.getDescription() : collection;
    }

    @Override
    public CollectionState head(StateTransitionOption ... options) {
        return (CollectionState)super.head(options);
    }

    @Override
    public CollectionState options(StateTransitionOption ... options) {
        return (CollectionState)super.options(options);
    }

    @Override
    public CollectionState get(StateTransitionOption ... options) {
        return (CollectionState)super.get(options);
    }

    @Override
    public CollectionState delete(StateTransitionOption ... options) {
        return (CollectionState)super.delete(options);
    }

    public CollectionState put(Gedcomx e, StateTransitionOption ... options) {
        return (CollectionState)super.put(e, options);
    }

    public CollectionState post(Gedcomx entity, StateTransitionOption ... options) {
        return (CollectionState)super.post(entity, options);
    }

    public Collection getCollection() {
        return this.getEntity() == null ? null : (((Gedcomx)this.getEntity()).getCollections() == null ? null : (((Gedcomx)this.getEntity()).getCollections().isEmpty() ? null : (Collection)((Gedcomx)this.getEntity()).getCollections().get(0)));
    }

    @Override
    public CollectionState authenticateWithAccessToken(String accessToken) {
        return (CollectionState)super.authenticateWithAccessToken(accessToken);
    }

    @Override
    public CollectionState authenticateViaOAuth2Password(String username, String password, String clientId) {
        return (CollectionState)super.authenticateViaOAuth2Password(username, password, clientId);
    }

    @Override
    public CollectionState authenticateViaOAuth2Password(String username, String password, String clientId, String clientSecret) {
        return (CollectionState)super.authenticateViaOAuth2Password(username, password, clientId, clientSecret);
    }

    @Override
    public CollectionState authenticateViaOAuth2AuthCode(String authCode, String redirect, String clientId) {
        return (CollectionState)super.authenticateViaOAuth2AuthCode(authCode, redirect, clientId);
    }

    @Override
    public CollectionState authenticateViaOAuth2AuthCode(String authCode, String redirect, String clientId, String clientSecret) {
        return (CollectionState)super.authenticateViaOAuth2AuthCode(authCode, redirect, clientId, clientSecret);
    }

    @Override
    public CollectionState authenticateViaOAuth2ClientCredentials(String clientId, String clientSecret) {
        return (CollectionState)super.authenticateViaOAuth2ClientCredentials(clientId, clientSecret);
    }

    @Override
    public CollectionState authenticateViaOAuth2(MultivaluedMap<String, String> formData, StateTransitionOption ... options) {
        return (CollectionState)super.authenticateViaOAuth2(formData, options);
    }

    public CollectionState update(Collection collection, StateTransitionOption ... options) {
        return this.post(new Gedcomx().collection(collection), options);
    }

    public RecordsState readRecords(StateTransitionOption ... options) {
        Link link = this.getLink("records");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newRecordsState(request, this.invoke(request, options), this.accessToken);
    }

    public RecordState addRecord(Gedcomx record, StateTransitionOption ... options) {
        Link link = this.getLink("records");
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException(String.format("Collection at %s doesn't support adding records.", this.getUri()));
        }
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)record)).build(link.getHref().toURI(), "POST");
        return this.stateFactory.newRecordState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonsState readPersons(StateTransitionOption ... options) {
        Link link = this.getLink("persons");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonsState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState addPerson(Person person, StateTransitionOption ... options) {
        Gedcomx entity = new Gedcomx();
        entity.addPerson(person);
        return this.addPerson(entity, options);
    }

    public PersonState addPerson(Gedcomx entity, StateTransitionOption ... options) {
        Link link = this.getLink("persons");
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException(String.format("Collection at %s doesn't support adding persons.", this.getUri()));
        }
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)entity)).build(link.getHref().toURI(), "POST");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readPersonForCurrentUser(StateTransitionOption ... options) {
        Link currentPersonLink = this.getLink("current-user-person");
        if (currentPersonLink == null || currentPersonLink.getHref() == null) {
            return null;
        }
        java.net.URI currentUserPersonUri = currentPersonLink.getHref().toURI();
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(currentUserPersonUri, "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readPerson(java.net.URI personUri, StateTransitionOption ... options) {
        if (personUri == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(personUri, "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonSearchResultsState searchForPersons(PersonSearchQueryBuilder query, StateTransitionOption ... options) {
        return this.searchForPersons(query.build(), options);
    }

    public PersonSearchResultsState searchForPersons(String query, StateTransitionOption ... options) {
        String uri;
        Link searchLink = this.getLink("person-search");
        if (searchLink == null || searchLink.getTemplate() == null) {
            return null;
        }
        String template = searchLink.getTemplate();
        try {
            uri = UriTemplate.fromTemplate((String)template).set("q", (Object)query).expand().replace("\"", "%22");
        }
        catch (VariableExpansionException e) {
            throw new GedcomxApplicationException(e);
        }
        catch (MalformedUriTemplateException e) {
            throw new GedcomxApplicationException(e);
        }
        ClientRequest request = this.createAuthenticatedFeedRequest().build(java.net.URI.create(uri), "GET");
        return this.stateFactory.newPersonSearchResultsState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipsState readRelationships(StateTransitionOption ... options) {
        Link link = this.getLink("relationships");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newRelationshipsState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipState addSpouseRelationship(PersonState person1, PersonState person2, StateTransitionOption ... options) {
        return this.addSpouseRelationship(person1, person2, (Fact)null, options);
    }

    public RelationshipState addSpouseRelationship(PersonState person1, PersonState person2, Fact fact, StateTransitionOption ... options) {
        Relationship relationship = new Relationship();
        relationship.setPerson1(new ResourceReference(new URI(person1.getSelfUri().toString())));
        relationship.setPerson2(new ResourceReference(new URI(person2.getSelfUri().toString())));
        relationship.setKnownType(RelationshipType.Couple);
        relationship.addFact(fact);
        return this.addRelationship(relationship, options);
    }

    public RelationshipState addParentChildRelationship(PersonState parent, PersonState child, StateTransitionOption ... options) {
        return this.addParentChildRelationship(parent, child, (Fact)null, options);
    }

    public RelationshipState addParentChildRelationship(PersonState parent, PersonState child, Fact fact, StateTransitionOption ... options) {
        Relationship relationship = new Relationship();
        relationship.setPerson1(new ResourceReference(new URI(parent.getSelfUri().toString())));
        relationship.setPerson2(new ResourceReference(new URI(child.getSelfUri().toString())));
        relationship.setKnownType(RelationshipType.ParentChild);
        relationship.addFact(fact);
        return this.addRelationship(relationship, options);
    }

    public RelationshipState addRelationship(Relationship relationship, StateTransitionOption ... options) {
        Link link = this.getLink("relationships");
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException(String.format("Collection at %s doesn't support adding relationships.", this.getUri()));
        }
        Gedcomx entity = new Gedcomx();
        entity.addRelationship(relationship);
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)entity)).build(link.getHref().toURI(), "POST");
        return this.stateFactory.newRelationshipState(request, this.invoke(request, options), this.accessToken);
    }

    public RelationshipsState addRelationships(List<Relationship> relationships, StateTransitionOption ... options) {
        Link link = this.getLink("relationships");
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException(String.format("Collection at %s doesn't support adding relationships.", this.getUri()));
        }
        Gedcomx entity = new Gedcomx();
        entity.setRelationships(relationships);
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)entity)).build(link.getHref().toURI(), "POST");
        return this.stateFactory.newRelationshipsState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionState addArtifact(DataSource artifact, StateTransitionOption ... options) {
        return this.addArtifact(null, artifact, options);
    }

    public SourceDescriptionState addArtifact(SourceDescription description, DataSource artifact, StateTransitionOption ... options) {
        return CollectionState.addArtifact(this, description, artifact, options);
    }

    static SourceDescriptionState addArtifact(GedcomxApplicationState state, SourceDescription description, DataSource artifact, StateTransitionOption ... options) {
        InputStream inputStream;
        Link link = state.getLink("artifacts");
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException(String.format("Resource at %s doesn't support adding artifacts.", state.getUri()));
        }
        FormDataMultiPart multiPart = new FormDataMultiPart();
        String mediaType = artifact.getContentType();
        if (description != null) {
            if (description.getTitles() != null) {
                for (TextValue value : description.getTitles()) {
                    multiPart.field("title", value.getValue());
                }
            }
            if (description.getDescriptions() != null) {
                for (TextValue value : description.getDescriptions()) {
                    multiPart.field("description", value.getValue());
                }
            }
            if (description.getCitations() != null) {
                for (SourceCitation citation : description.getCitations()) {
                    multiPart.field("citation", citation.getValue());
                }
            }
            if (description.getMediaType() != null) {
                mediaType = description.getMediaType();
            }
        }
        if (mediaType == null) {
            mediaType = "application/octet-stream";
        }
        try {
            inputStream = artifact.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        FormDataContentDisposition.FormDataContentDispositionBuilder cd = FormDataContentDisposition.name((String)"artifact");
        if (artifact.getName() != null) {
            cd = (FormDataContentDisposition.FormDataContentDispositionBuilder)cd.fileName(artifact.getName());
        }
        FormDataBodyPart artifactPart = new FormDataBodyPart(cd.build(), (Object)inputStream, MediaType.valueOf((String)mediaType));
        multiPart.getBodyParts().add(artifactPart);
        ClientRequest request = ((ClientRequest.Builder)((ClientRequest.Builder)state.createAuthenticatedGedcomxRequest().type(MediaType.MULTIPART_FORM_DATA_TYPE)).entity((Object)multiPart)).build(link.getHref().toURI(), "POST");
        return state.stateFactory.newSourceDescriptionState(request, state.invoke(request, options), state.accessToken);
    }

    public SourceDescriptionsState readSourceDescriptions(StateTransitionOption ... options) {
        Link link = this.getLink("source-descriptions");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newSourceDescriptionsState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionState addSourceDescription(SourceDescription source, StateTransitionOption ... options) {
        Link link = this.getLink("source-descriptions");
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException(String.format("Collection at %s doesn't support adding source descriptions.", this.getUri()));
        }
        Gedcomx entity = new Gedcomx();
        entity.addSourceDescription(source);
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)entity)).build(link.getHref().toURI(), "POST");
        return this.stateFactory.newSourceDescriptionState(request, this.invoke(request, options), this.accessToken);
    }

    public CollectionState readCollection(StateTransitionOption ... options) {
        Link link = this.getLink("collection");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public CollectionsState readSubcollections(StateTransitionOption ... options) {
        Link link = this.getLink("subcollections");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newCollectionsState(request, this.invoke(request, options), this.accessToken);
    }

    public CollectionState addCollection(Collection collection, StateTransitionOption ... options) {
        return this.addCollection(collection, (SourceDescription)null, options);
    }

    public CollectionState addCollection(SourceDescription sourceDescription, StateTransitionOption ... options) {
        return this.addCollection(null, sourceDescription, options);
    }

    public CollectionState addCollection(Collection collection, SourceDescription sourceDescription, StateTransitionOption ... options) {
        Link link = this.getLink("subcollections");
        if (link == null || link.getHref() == null) {
            throw new GedcomxApplicationException(String.format("Collection at %s doesn't support adding subcollections.", this.getUri()));
        }
        ClientRequest request = ((ClientRequest.Builder)this.createAuthenticatedGedcomxRequest().entity((Object)new Gedcomx().collection(collection).sourceDescription(sourceDescription))).build(link.getHref().toURI(), "POST");
        return this.stateFactory.newCollectionState(request, this.invoke(request, options), this.accessToken);
    }

    public SourceDescriptionsState readResourcesOfCurrentUser(StateTransitionOption ... options) {
        Link link = this.getLink("current-user-resources");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newSourceDescriptionsState(request, this.invoke(request, options), this.accessToken);
    }

    public List<SourceDescription> getSourceDescriptions() {
        return this.entity == null ? null : ((Gedcomx)this.entity).getSourceDescriptions();
    }

    public SourceDescriptionState readSourceDescription(SourceDescription sourceDescription, StateTransitionOption ... options) {
        Link link = sourceDescription.getLink("description");
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newSourceDescriptionState(request, this.invoke(request, options), this.accessToken);
    }

    public PersonState readPerson(Person person, StateTransitionOption ... options) {
        Link link = person.getLink("person");
        if (link == null) {
            link = person.getLink("self");
        }
        if (link == null || link.getHref() == null) {
            return null;
        }
        ClientRequest request = this.createAuthenticatedGedcomxRequest().build(link.getHref().toURI(), "GET");
        return this.stateFactory.newPersonState(request, this.invoke(request, options), this.accessToken);
    }
}

