/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client.util;

import java.util.ArrayList;
import org.gedcomx.Gedcomx;
import org.gedcomx.conclusion.DisplayProperties;
import org.gedcomx.conclusion.Person;

public class AncestryTree {
    private final ArrayList<Person> ancestry;

    public AncestryTree(Gedcomx gx) {
        this.ancestry = this.buildArray(gx);
    }

    protected ArrayList<Person> buildArray(Gedcomx gx) {
        ArrayList<Person> ancestry = new ArrayList<Person>();
        if (gx.getPersons() != null) {
            for (Person person : gx.getPersons()) {
                DisplayProperties display = person.getDisplayExtension();
                if (display == null || display.getAscendancyNumber() == null) continue;
                try {
                    int number = Integer.parseInt(display.getAscendancyNumber());
                    while (ancestry.size() < number) {
                        ancestry.add(null);
                    }
                    ancestry.set(number - 1, person);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return ancestry;
    }

    public AncestryNode getRoot() {
        return this.getAncestor(1);
    }

    public AncestryNode getAncestor(int number) {
        return this.ancestry.size() < number ? null : new AncestryNode(number);
    }

    public class AncestryNode {
        private final int number;

        public AncestryNode(int number) {
            this.number = number;
        }

        public Person getPerson() {
            return (Person)AncestryTree.this.ancestry.get(this.number - 1);
        }

        public AncestryNode getFather() {
            return AncestryTree.this.getAncestor(this.number * 2);
        }

        public AncestryNode getMother() {
            return AncestryTree.this.getAncestor(this.number * 2 + 1);
        }
    }
}

