/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rs.client.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.ws.rs.core.MediaType;
import org.gedcomx.atom.Feed;
import org.gedcomx.common.URI;
import org.gedcomx.links.Link;

public class PagedFeedIterator
implements Iterator<Feed> {
    public static WebResourceProvider DEFAULT_WEB_RESOURCE_PROVIDER = new WebResourceProvider(){

        @Override
        public WebResource provide(Client client, URI uri) {
            return client.resource(uri.toURI());
        }
    };
    private final List<WebResourceBuilderExtension> extensions = new ArrayList<WebResourceBuilderExtension>();
    private Client client;
    private WebResourceProvider webResourceProvider = DEFAULT_WEB_RESOURCE_PROVIDER;
    private URI first = null;
    private URI last = null;
    private URI previous = null;
    private URI next = null;

    private PagedFeedIterator(URI uri) {
        this.next = uri;
    }

    private PagedFeedIterator(Feed feed) {
        this.loadHRefsFromFeed(feed);
    }

    public static PagedFeedIterator fromUri(URI uri) {
        return new PagedFeedIterator(uri);
    }

    public static PagedFeedIterator fromFeed(Feed feed) {
        return new PagedFeedIterator(feed);
    }

    public static URI getLinkRelHref(Feed feed, String rel) {
        Link link = feed.getLink(rel);
        return link == null ? null : link.getHref();
    }

    public List<WebResourceBuilderExtension> getWebResourceBuilderExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public synchronized void addWebResourceBuilderExtension(WebResourceBuilderExtension extension) {
        this.extensions.add(extension);
    }

    public synchronized void removeWebResourceBuilderExtension(WebResourceBuilderExtension extension) {
        this.extensions.remove(extension);
    }

    public synchronized void clearWebResourceBuilderExtensions() {
        this.extensions.clear();
    }

    public PagedFeedIterator withWebResourceBuilderExtension(WebResourceBuilderExtension extension) {
        this.addWebResourceBuilderExtension(extension);
        return this;
    }

    public Client getClient() {
        if (this.client == null) {
            this.withClient(Client.create());
        }
        return this.client;
    }

    public synchronized void setClient(Client client) {
        this.client = client;
    }

    public PagedFeedIterator withClient(Client client) {
        this.setClient(client);
        return this;
    }

    public WebResourceProvider getWebResourceProvider() {
        return this.webResourceProvider;
    }

    public void setWebResourceProvider(WebResourceProvider webResourceProvider) {
        this.webResourceProvider = webResourceProvider;
    }

    public PagedFeedIterator withWebResourceProvider(WebResourceProvider webResourceProvider) {
        this.setWebResourceProvider(webResourceProvider);
        return this;
    }

    public boolean hasFirst() {
        return this.first != null;
    }

    public URI firstHRef() {
        return this.first;
    }

    public Feed first() {
        if (!this.hasFirst()) {
            throw new NoSuchElementException();
        }
        return this.getFeed(this.first);
    }

    public URI lastHRef() {
        return this.last;
    }

    public boolean hasLast() {
        return this.last != null;
    }

    public Feed last() {
        if (!this.hasLast()) {
            throw new NoSuchElementException();
        }
        return this.getFeed(this.last);
    }

    public URI previousHRef() {
        return this.previous;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    public Feed previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.getFeed(this.previous);
    }

    public URI nextHRef() {
        return this.next;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Feed next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getFeed(this.next);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadHRefsFromFeed(Feed feed) {
        this.first = PagedFeedIterator.getLinkRelHref(feed, "first");
        this.last = PagedFeedIterator.getLinkRelHref(feed, "last");
        this.previous = PagedFeedIterator.getLinkRelHref(feed, "previous");
        this.next = PagedFeedIterator.getLinkRelHref(feed, "next");
    }

    private synchronized Feed getFeed(URI uri) {
        WebResource.Builder builder = this.webResourceProvider.provide(this.getClient(), uri).accept(new MediaType[]{MediaType.APPLICATION_ATOM_XML_TYPE});
        for (WebResourceBuilderExtension extension : this.extensions) {
            builder = extension.extend(builder);
        }
        ClientResponse clientResponse = (ClientResponse)builder.get(ClientResponse.class);
        ClientResponse.Status status = clientResponse.getClientResponseStatus();
        switch (status) {
            case OK: {
                Feed feed = (Feed)clientResponse.getEntity(Feed.class);
                this.loadHRefsFromFeed(feed);
                return feed;
            }
            case NO_CONTENT: {
                return null;
            }
        }
        throw new IllegalStateException(status.toString());
    }

    public static interface WebResourceBuilderExtension {
        public WebResource.Builder extend(WebResource.Builder var1);
    }

    public static interface WebResourceProvider {
        public WebResource provide(Client var1, URI var2);
    }
}

