/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.fmt;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.JTypeVar;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;

public final class JStaticJavaFile
extends JResourceFile {
    private final JPackage pkg;
    private final String className;
    private final ResourceLoader source;
    private final JStaticClass clazz;
    private final LineFilter filter;

    public JStaticJavaFile(JPackage _pkg, String _className, Class<?> loadingClass, LineFilter _filter) {
        super(_className + ".java");
        if (loadingClass == null) {
            throw new NullPointerException();
        }
        this.pkg = _pkg;
        this.clazz = new JStaticClass();
        this.className = _className;
        this.source = new ResourceLoader(_className, loadingClass);
        this.filter = _filter;
    }

    public final JClass getJClass() {
        return this.clazz;
    }

    @Override
    protected boolean isResource() {
        return false;
    }

    @Override
    protected void build(OutputStream os) throws IOException {
        int lineNumber = 1;
        try (InputStream is = this.source.getResourceAsStream();
             BufferedReader r = new BufferedReader(new InputStreamReader(is));
             PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));){
            String line;
            LineFilter filter = this.createLineFilter();
            while ((line = r.readLine()) != null) {
                if ((line = filter.process(line)) != null) {
                    w.println(line);
                }
                ++lineNumber;
            }
        }
        catch (ParseException e) {
            throw new IOException("unable to process " + this.source + " line:" + lineNumber + "\n" + e.getMessage());
        }
    }

    private LineFilter createLineFilter() {
        LineFilter f = new LineFilter(){

            @Override
            public String process(String line) {
                if (!line.startsWith("package ")) {
                    return line;
                }
                if (JStaticJavaFile.this.pkg.isUnnamed()) {
                    return null;
                }
                return "package " + JStaticJavaFile.this.pkg.name() + ";";
            }
        };
        if (this.filter != null) {
            return new ChainFilter(this.filter, f);
        }
        return f;
    }

    static class ResourceLoader {
        Class<?> loadingClass;
        String shortName;

        ResourceLoader(String shortName, Class<?> loadingClass) {
            this.loadingClass = loadingClass;
            this.shortName = shortName;
        }

        InputStream getResourceAsStream() {
            InputStream stream = this.loadingClass.getResourceAsStream(this.shortName + ".java");
            if (stream == null) {
                stream = this.loadingClass.getResourceAsStream(this.shortName + ".java_");
            }
            if (stream == null) {
                throw new InternalError("Unable to load source code of " + this.loadingClass.getName() + " as a resource");
            }
            return stream;
        }
    }

    private class JStaticClass
    extends JClass {
        private final JTypeVar[] typeParams;

        JStaticClass() {
            super(JStaticJavaFile.this.pkg.owner());
            this.typeParams = new JTypeVar[0];
        }

        @Override
        public String name() {
            return JStaticJavaFile.this.className;
        }

        @Override
        public String fullName() {
            if (JStaticJavaFile.this.pkg.isUnnamed()) {
                return JStaticJavaFile.this.className;
            }
            return JStaticJavaFile.this.pkg.name() + '.' + JStaticJavaFile.this.className;
        }

        @Override
        public JPackage _package() {
            return JStaticJavaFile.this.pkg;
        }

        @Override
        public JClass _extends() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<JClass> _implements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInterface() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAbstract() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JTypeVar[] typeParams() {
            return this.typeParams;
        }

        @Override
        protected JClass substituteParams(JTypeVar[] variables, List<JClass> bindings) {
            return this;
        }
    }

    public static final class ChainFilter
    implements LineFilter {
        private final LineFilter first;
        private final LineFilter second;

        public ChainFilter(LineFilter first, LineFilter second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public String process(String line) throws ParseException {
            if ((line = this.first.process(line)) == null) {
                return null;
            }
            return this.second.process(line);
        }
    }

    public static interface LineFilter {
        public String process(String var1) throws ParseException;
    }
}

