/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Maps;
import io.searchbox.core.search.aggregation.StatsAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog2.indexer.results.IndexQueryResult;

public class TermsStatsResult
extends IndexQueryResult {
    private static final Comparator<Map<String, Object>> COMPARATOR = (o1, o2) -> {
        double o2Mean;
        double o1Mean = (Double)o1.get("mean");
        if (o1Mean > (o2Mean = ((Double)o2.get("mean")).doubleValue())) {
            return -1;
        }
        if (o1Mean < o2Mean) {
            return 1;
        }
        return 0;
    };
    private final List<Map<String, Object>> terms;

    public TermsStatsResult(TermsAggregation terms, String originalQuery, String builtQuery, long tookMs) {
        super(originalQuery, builtQuery, tookMs);
        this.terms = terms.getBuckets().stream().map(e -> {
            HashMap resultMap = Maps.newHashMap();
            resultMap.put("key_field", e.getKey());
            resultMap.put("count", e.getCount());
            StatsAggregation stats = e.getStatsAggregation("gl2_stats");
            resultMap.put("min", stats.getMin());
            resultMap.put("max", stats.getMax());
            resultMap.put("total", stats.getSum());
            resultMap.put("total_count", stats.getCount());
            resultMap.put("mean", stats.getAvg());
            return resultMap;
        }).sorted(COMPARATOR).collect(Collectors.toList());
    }

    private TermsStatsResult(String originalQuery, String builtQuery) {
        super(originalQuery, builtQuery, 0L);
        this.terms = Collections.emptyList();
    }

    public static TermsStatsResult empty(String originalQuery, String builtQuery) {
        return new TermsStatsResult(originalQuery, builtQuery);
    }

    public List<Map<String, Object>> getResults() {
        return this.terms;
    }
}

