/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.extractors;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.graylog2.ConfigurationException;
import org.graylog2.inputs.extractors.AutoValue_JsonExtractor_Entry;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonExtractor
extends Extractor {
    private static final Logger LOG = LoggerFactory.getLogger(JsonExtractor.class);
    private static final String CK_FLATTEN = "flatten";
    private static final String CK_LIST_SEPARATOR = "list_separator";
    private static final String CK_KEY_SEPARATOR = "key_separator";
    private static final String CK_KV_SEPARATOR = "kv_separator";
    private static final String CK_REPLACE_KEY_WHITESPACE = "replace_key_whitespace";
    private static final String CK_KEY_WHITESPACE_REPLACEMENT = "key_whitespace_replacement";
    private static final String CK_KEY_PREFIX = "key_prefix";
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s");
    private static final RemoveNullPredicate REMOVE_NULL_PREDICATE = new RemoveNullPredicate();
    private final ObjectMapper mapper = new ObjectMapper();
    private final boolean flatten;
    private final String listSeparator;
    private final String keySeparator;
    private final String kvSeparator;
    private final boolean replaceKeyWhitespace;
    private final String keyWhitespaceReplacement;
    private final String keyPrefix;

    public JsonExtractor(MetricRegistry metricRegistry, String id, String title, long order, Extractor.CursorStrategy cursorStrategy, String sourceField, String targetField, Map<String, Object> extractorConfig, String creatorUserId, List<Converter> converters, Extractor.ConditionType conditionType, String conditionValue) throws Extractor.ReservedFieldException, ConfigurationException {
        super(metricRegistry, id, title, order, Extractor.Type.JSON, cursorStrategy, sourceField, targetField, extractorConfig, creatorUserId, converters, conditionType, conditionValue);
        if (extractorConfig == null) {
            throw new ConfigurationException("Missing extractor configuration");
        }
        this.flatten = (Boolean)MoreObjects.firstNonNull((Object)((Boolean)extractorConfig.get(CK_FLATTEN)), (Object)false);
        this.listSeparator = (String)MoreObjects.firstNonNull((Object)((String)extractorConfig.get(CK_LIST_SEPARATOR)), (Object)", ");
        this.keySeparator = (String)MoreObjects.firstNonNull((Object)((String)extractorConfig.get(CK_KEY_SEPARATOR)), (Object)"_");
        this.kvSeparator = (String)MoreObjects.firstNonNull((Object)((String)extractorConfig.get(CK_KV_SEPARATOR)), (Object)"=");
        this.replaceKeyWhitespace = (Boolean)MoreObjects.firstNonNull((Object)((Boolean)extractorConfig.get(CK_REPLACE_KEY_WHITESPACE)), (Object)false);
        this.keyWhitespaceReplacement = (String)MoreObjects.firstNonNull((Object)((String)extractorConfig.get(CK_KEY_WHITESPACE_REPLACEMENT)), (Object)"_");
        this.keyPrefix = (String)MoreObjects.firstNonNull((Object)((String)extractorConfig.get(CK_KEY_PREFIX)), (Object)"");
    }

    @Override
    protected Extractor.Result[] run(String value) {
        Map<String, Object> extractedJson = this.extractJson(value);
        ArrayList<Extractor.Result> results = new ArrayList<Extractor.Result>(extractedJson.size());
        for (Map.Entry<String, Object> entry : extractedJson.entrySet()) {
            results.add(new Extractor.Result(entry.getValue(), entry.getKey(), -1, -1));
        }
        return results.toArray(new Extractor.Result[results.size()]);
    }

    public Map<String, Object> extractJson(String value) {
        Map json;
        if (Strings.isNullOrEmpty((String)value)) {
            return Collections.emptyMap();
        }
        try {
            json = (Map)this.mapper.readValue(value, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> results = new HashMap<String, Object>(json.size());
        for (Map.Entry mapEntry : json.entrySet()) {
            for (Entry entry : this.parseValue(this.keyPrefix + (String)mapEntry.getKey(), mapEntry.getValue())) {
                results.put(entry.key(), entry.value());
            }
        }
        return results;
    }

    private String parseKey(String key) {
        if (this.replaceKeyWhitespace && key.contains(" ")) {
            return WHITE_SPACE_PATTERN.matcher(key).replaceAll(this.keyWhitespaceReplacement);
        }
        if (LOG.isDebugEnabled() && key.contains(" ")) {
            LOG.debug("Invalid key \"{}\" in JSON object!", (Object)key);
        }
        return key;
    }

    private Collection<Entry> parseValue(String key, Object value) {
        String processedKey = this.parseKey(key);
        if (value instanceof Boolean) {
            return Collections.singleton(Entry.create(processedKey, value));
        }
        if (value instanceof Number) {
            return Collections.singleton(Entry.create(processedKey, value));
        }
        if (value instanceof String) {
            return Collections.singleton(Entry.create(processedKey, value));
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            Map withoutNull = Maps.filterEntries((Map)map, (Predicate)REMOVE_NULL_PREDICATE);
            if (this.flatten) {
                Joiner.MapJoiner joiner = Joiner.on((String)this.listSeparator).withKeyValueSeparator(this.kvSeparator);
                return Collections.singleton(Entry.create(processedKey, joiner.join(withoutNull)));
            }
            ArrayList<Entry> result = new ArrayList<Entry>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                result.addAll(this.parseValue(processedKey + this.keySeparator + (String)entry.getKey(), entry.getValue()));
            }
            return result;
        }
        if (value instanceof List) {
            List values = (List)value;
            Joiner joiner = Joiner.on((String)this.listSeparator).skipNulls();
            return Collections.singleton(Entry.create(processedKey, joiner.join((Iterable)values)));
        }
        if (value == null) {
            return Collections.emptySet();
        }
        LOG.debug("Unknown type \"{}\" in key \"{}\"", value.getClass(), (Object)key);
        return Collections.emptySet();
    }

    protected static final class RemoveNullPredicate
    implements Predicate<Map.Entry> {
        protected RemoveNullPredicate() {
        }

        public boolean apply(@Nullable Map.Entry input) {
            return input != null && input.getKey() != null && input.getValue() != null;
        }
    }

    protected static abstract class Entry {
        protected Entry() {
        }

        public abstract String key();

        @Nullable
        public abstract Object value();

        public static Entry create(String key, @Nullable Object value) {
            return new AutoValue_JsonExtractor_Entry(key, value);
        }
    }
}

