/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.graylog2.outputs.GelfOutput;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.journal.Journal;

public class BenchmarkOutput
implements MessageOutput {
    private static final List<String> SKIPPED_METRIC_PREFIXES = ImmutableList.of((Object)"org.graylog2.rest.resources");
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final Meter messagesWritten;
    private final CsvReporter csvReporter;
    private final Journal journal;

    @AssistedInject
    public BenchmarkOutput(MetricRegistry metricRegistry, Journal journal, @Assisted Stream stream, @Assisted Configuration configuration) {
        this(metricRegistry, journal);
    }

    @Inject
    public BenchmarkOutput(MetricRegistry metricRegistry, Journal journal) {
        this.journal = journal;
        this.messagesWritten = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"messagesWritten"}));
        File directory = new File("benchmark-csv");
        directory.mkdirs();
        this.csvReporter = CsvReporter.forRegistry((MetricRegistry)metricRegistry).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter((MetricFilter)new CsvMetricFilter(SKIPPED_METRIC_PREFIXES)).build(directory);
        this.csvReporter.start(1L, TimeUnit.SECONDS);
        this.isRunning.set(true);
    }

    @Override
    public void stop() {
        this.csvReporter.stop();
        this.isRunning.set(false);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    @Override
    public void write(Message message) throws Exception {
        this.journal.markJournalOffsetCommitted(message.getJournalOffset());
        this.messagesWritten.mark();
    }

    @Override
    public void write(List<Message> messages) throws Exception {
        long maxOffset = Long.MIN_VALUE;
        for (Message message : messages) {
            maxOffset = Math.max(message.getJournalOffset(), maxOffset);
        }
        this.journal.markJournalOffsetCommitted(maxOffset);
        this.messagesWritten.mark((long)messages.size());
    }

    private static class CsvMetricFilter
    implements MetricFilter {
        private final List<String> prefixes;

        public CsvMetricFilter(List<String> prefixes) {
            this.prefixes = prefixes;
        }

        public boolean matches(String name, Metric metric) {
            for (String prefix : this.prefixes) {
                if (!name.startsWith(prefix)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Descriptor
    extends MessageOutput.Descriptor {
        public Descriptor() {
            super("Benchmark output", false, "", "Output that benchmarks message rates");
        }
    }

    public static class Config
    extends MessageOutput.Config {
    }

    public static interface Factory
    extends MessageOutput.Factory<GelfOutput> {
        @Override
        public GelfOutput create(Stream var1, Configuration var2);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

