/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.alerts;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alerts.AlertService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.streams.alerts.AlertConditionListSummary;
import org.graylog2.rest.models.streams.alerts.AlertConditionSummary;
import org.graylog2.rest.models.streams.alerts.requests.CreateConditionRequest;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.graylog2.utilities.ConfigurationMapConverter;

@RequiresAuthentication
@Api(value="Stream/AlertConditions", description="Manage stream alert conditions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/streams/{streamId}/alerts/conditions")
public class StreamAlertConditionResource
extends RestResource {
    private final StreamService streamService;
    private final AlertService alertService;
    private final Map<String, AlertCondition.Factory> alertConditionMap;

    @Inject
    public StreamAlertConditionResource(StreamService streamService, AlertService alertService, Map<String, AlertCondition.Factory> alertConditionMap) {
        this.streamService = streamService;
        this.alertService = alertService;
        this.alertConditionMap = alertConditionMap;
    }

    @POST
    @Timed
    @ApiOperation(value="Create an alert condition")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:alert_condition:create")
    public Response create(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateConditionRequest ccr) throws NotFoundException, ValidationException {
        this.checkPermission("streams:edit", streamid);
        Stream stream = this.streamService.load(streamid);
        try {
            AlertCondition alertCondition = this.alertService.fromRequest(this.convertConfigurationInRequest(ccr), stream, this.getCurrentUser().getName());
            this.streamService.addAlertCondition(stream, alertCondition);
            ImmutableMap result = ImmutableMap.of((Object)"alert_condition_id", (Object)alertCondition.getId());
            URI alertConditionUri = this.getUriBuilderToSelf().path(StreamAlertConditionResource.class).path("{conditionId}").build(new Object[]{stream.getId(), alertCondition.getId()});
            return Response.created((URI)alertConditionUri).entity((Object)result).build();
        }
        catch (ConfigurationException e) {
            throw new BadRequestException("Invalid alert condition parameters", (Throwable)e);
        }
    }

    @PUT
    @Timed
    @Path(value="{conditionId}")
    @ApiOperation(value="Modify an alert condition")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:alert_condition:update")
    public void update(@ApiParam(name="streamId", value="The stream id the alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid, @ApiParam(name="conditionId", value="The alert condition id.", required=true) @PathParam(value="conditionId") String conditionid, @ApiParam(name="JSON body", required=true) @Valid @NotNull CreateConditionRequest ccr) throws NotFoundException, ValidationException {
        this.checkPermission("streams:edit", streamid);
        Stream stream = this.streamService.load(streamid);
        AlertCondition alertCondition = this.streamService.getAlertCondition(stream, conditionid);
        try {
            AlertCondition updatedCondition = this.alertService.updateFromRequest(alertCondition, this.convertConfigurationInRequest(ccr));
            this.streamService.updateAlertCondition(stream, updatedCondition);
        }
        catch (ConfigurationException e) {
            throw new BadRequestException("Invalid alert condition parameters", (Throwable)e);
        }
    }

    @GET
    @Timed
    @ApiOperation(value="Get all alert conditions of this stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public AlertConditionListSummary list(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid) throws NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        List<AlertCondition> alertConditions = this.streamService.getAlertConditions(stream);
        List<AlertConditionSummary> conditionSummaries = alertConditions.stream().map(condition -> AlertConditionSummary.create(condition.getId(), condition.getType(), condition.getCreatorUserId(), condition.getCreatedAt().toDate(), condition.getParameters(), this.alertService.inGracePeriod((AlertCondition)condition), condition.getTitle())).collect(Collectors.toList());
        return AlertConditionListSummary.create(conditionSummaries);
    }

    @DELETE
    @Timed
    @Path(value="{conditionId}")
    @ApiOperation(value="Delete an alert condition")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:alert_condition:delete")
    public void delete(@ApiParam(name="streamId", value="The stream id this alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid, @ApiParam(name="conditionId", value="The alert condition id to be deleted", required=true) @PathParam(value="conditionId") String conditionId) throws NotFoundException {
        this.checkPermission("streams:edit", streamid);
        Stream stream = this.streamService.load(streamid);
        this.streamService.removeAlertCondition(stream, conditionId);
    }

    @GET
    @Timed
    @Path(value="{conditionId}")
    @ApiOperation(value="Get an alert condition")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:alert_condition:delete")
    public AlertConditionSummary get(@ApiParam(name="streamId", value="The stream id this alert condition belongs to.", required=true) @PathParam(value="streamId") String streamId, @ApiParam(name="conditionId", value="The alert condition id to be fetched", required=true) @PathParam(value="conditionId") String conditionId) throws NotFoundException {
        this.checkPermission("streams:read", streamId);
        Stream stream = this.streamService.load(streamId);
        AlertCondition condition = this.streamService.getAlertCondition(stream, conditionId);
        return AlertConditionSummary.create(condition.getId(), condition.getType(), condition.getCreatorUserId(), condition.getCreatedAt().toDate(), condition.getParameters(), this.alertService.inGracePeriod(condition), condition.getTitle());
    }

    private CreateConditionRequest convertConfigurationInRequest(CreateConditionRequest request) {
        Map<String, Object> parameters;
        AlertCondition.Factory factory = this.alertConditionMap.get(request.type());
        if (factory == null) {
            throw new BadRequestException("Unable to load alert condition of type " + request.type());
        }
        ConfigurationRequest requestedConfiguration = factory.config().getRequestedConfiguration();
        try {
            parameters = ConfigurationMapConverter.convertValues(request.parameters(), requestedConfiguration);
        }
        catch (ValidationException e) {
            throw new BadRequestException("Invalid alert condition parameters", (Throwable)e);
        }
        return request.toBuilder().setParameters(parameters).build();
    }
}

