/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Locale;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.rest.models.system.indexer.responses.ClusterHealth;
import org.graylog2.rest.models.system.indexer.responses.ClusterName;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="Indexer/Cluster", description="Indexer cluster information")
@Path(value="/system/indexer/cluster")
public class IndexerClusterResource
extends RestResource {
    @Inject
    private Cluster cluster;

    @GET
    @Timed
    @Path(value="/name")
    @RequiresPermissions(value={"indexercluster:read"})
    @ApiOperation(value="Get the cluster name")
    @Produces(value={"application/json"})
    public ClusterName clusterName() {
        JsonNode health = this.cluster.health().orElseThrow(() -> new InternalServerErrorException("Couldn't read Elasticsearch cluster health"));
        String clusterName = health.path("cluster_name").asText("<unknown>");
        return ClusterName.create(clusterName);
    }

    @GET
    @Timed
    @Path(value="/health")
    @ApiOperation(value="Get cluster and shard health overview")
    @RequiresPermissions(value={"indexercluster:read"})
    @Produces(value={"application/json"})
    public ClusterHealth clusterHealth() {
        JsonNode health = this.cluster.health().orElseThrow(() -> new InternalServerErrorException("Couldn't read Elasticsearch cluster health"));
        ClusterHealth.ShardStatus shards = ClusterHealth.ShardStatus.create(health.path("active_shards").asInt(), health.path("initializing_shards").asInt(), health.path("relocating_shards").asInt(), health.path("unassigned_shards").asInt());
        return ClusterHealth.create(health.path("status").asText().toLowerCase(Locale.ENGLISH), shards);
    }
}

