/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.plugin.security.PasswordAlgorithm;
import org.graylog2.users.DefaultPasswordAlgorithm;

public class PasswordAlgorithmFactory {
    private final Map<String, PasswordAlgorithm> passwordAlgorithms;
    private final PasswordAlgorithm defaultPasswordAlgorithm;

    @Inject
    public PasswordAlgorithmFactory(Map<String, PasswordAlgorithm> passwordAlgorithms, @DefaultPasswordAlgorithm PasswordAlgorithm defaultPasswordAlgorithm) {
        this.passwordAlgorithms = passwordAlgorithms;
        this.defaultPasswordAlgorithm = defaultPasswordAlgorithm;
    }

    @Nullable
    public PasswordAlgorithm forPassword(String hashedPassword) {
        for (PasswordAlgorithm passwordAlgorithm : this.passwordAlgorithms.values()) {
            if (!passwordAlgorithm.supports(hashedPassword)) continue;
            return passwordAlgorithm;
        }
        return null;
    }

    @Nullable
    public PasswordAlgorithm forName(String name) {
        return this.passwordAlgorithms.get(name);
    }

    public PasswordAlgorithm defaultPasswordAlgorithm() {
        return this.defaultPasswordAlgorithm;
    }
}

