/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security.ldap;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class LdapEntry {
    private Map<String, String> attributes = Maps.newHashMap();
    private Set<String> groups = Sets.newHashSet();
    private String dn;
    private String bindPrincipal;

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getDn() {
        return this.dn;
    }

    public String getBindPrincipal() {
        return this.bindPrincipal;
    }

    public void setBindPrincipal(String bindPrincipal) {
        this.bindPrincipal = bindPrincipal;
    }

    public String get(String key) {
        return this.attributes.get(key.toLowerCase(Locale.ENGLISH));
    }

    public String put(String key, String value) {
        return this.attributes.put(key.toLowerCase(Locale.ENGLISH), value);
    }

    public void addGroups(Collection<String> groups) {
        this.groups.addAll(groups);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getEmail() {
        String email = this.get("mail");
        if (email == null) {
            email = this.get("rfc822Mailbox");
        }
        return email;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("dn", (Object)this.dn).add("bindPrincipal", (Object)this.bindPrincipal).add("attributes", this.attributes).add("groups", this.groups).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LdapEntry ldapEntry = (LdapEntry)o;
        return Objects.equals(this.attributes, ldapEntry.attributes) && Objects.equals(this.groups, ldapEntry.groups) && Objects.equals(this.dn, ldapEntry.dn) && Objects.equals(this.bindPrincipal, ldapEntry.bindPrincipal);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.groups, this.dn, this.bindPrincipal);
    }
}

