/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.plugin.Plugin;
import org.graylog2.shared.plugins.PluginLoader;
import org.graylog2.web.ModuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAssets {
    private static final Logger LOG = LoggerFactory.getLogger(PluginAssets.class);
    public static final String pathPrefix = "web-interface/assets";
    private static final String pluginPathPrefix = "plugin/";
    private static final String manifestFilename = "module.json";
    private static final String vendorManifestFilename = "vendor-module.json";
    private final ObjectMapper objectMapper;
    private final List<String> jsFiles;
    private final List<String> cssFiles;
    private final String polyfillJsFile;
    private final List<String> vendorJsFiles;

    @Inject
    public PluginAssets(Set<Plugin> plugins, ObjectMapper objectMapper) {
        ModuleManifest manifest;
        ModuleManifest vendorManifest;
        this.objectMapper = objectMapper;
        this.jsFiles = new ArrayList<String>();
        this.cssFiles = new ArrayList<String>();
        InputStream vendorManifestStream = this.getClass().getResourceAsStream("/web-interface/assets/vendor-module.json");
        if (vendorManifestStream != null) {
            try {
                vendorManifest = (ModuleManifest)objectMapper.readValue(vendorManifestStream, ModuleManifest.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read vendor manifest: ", e);
            }
        } else {
            throw new IllegalStateException("Unable to find vendor assets. Maybe the web interface was not built into server?");
        }
        this.vendorJsFiles = vendorManifest.files().jsFiles();
        this.jsFiles.addAll(vendorManifest.files().jsFiles());
        this.cssFiles.addAll(vendorManifest.files().cssFiles());
        plugins.forEach(plugin -> {
            ModuleManifest pluginManifest = this.manifestForPlugin((Plugin)plugin);
            String pathPrefix = pluginPathPrefix + plugin.metadata().getUniqueId() + "/";
            if (pluginManifest != null) {
                this.jsFiles.addAll(this.prefixFileNames(pluginManifest.files().jsFiles(), pathPrefix));
                this.cssFiles.addAll(this.prefixFileNames(pluginManifest.files().cssFiles(), pathPrefix));
            }
        });
        InputStream packageManifestStream = this.getClass().getResourceAsStream("/web-interface/assets/module.json");
        if (packageManifestStream != null) {
            try {
                manifest = (ModuleManifest)objectMapper.readValue(packageManifestStream, ModuleManifest.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read web interface manifest: ", e);
            }
        } else {
            throw new IllegalStateException("Unable to find web interface assets. Maybe the web interface was not built into server?");
        }
        this.jsFiles.addAll(manifest.files().jsFiles());
        this.cssFiles.addAll(manifest.files().cssFiles());
        this.polyfillJsFile = manifest.files().chunks().get("polyfill").entry();
    }

    private List<String> jsFiles() {
        return this.jsFiles;
    }

    List<String> sortedJsFiles() {
        return this.jsFiles().stream().sorted((file1, file2) -> {
            if (this.vendorJsFiles.contains(file1)) {
                return -1;
            }
            if (this.vendorJsFiles.contains(file2)) {
                return 1;
            }
            if (file1.equals(this.polyfillJsFile)) {
                return -1;
            }
            if (file2.equals(this.polyfillJsFile)) {
                return 1;
            }
            return file2.compareTo((String)file1);
        }).collect(Collectors.toList());
    }

    List<String> cssFiles() {
        return this.cssFiles;
    }

    private List<String> prefixFileNames(List<String> filenames, String pathPrefix) {
        return filenames.stream().map(file -> file.startsWith(pathPrefix) ? file : pathPrefix + file).collect(Collectors.toList());
    }

    @Nullable
    private ModuleManifest manifestForPlugin(Plugin plugin) {
        if (!(plugin instanceof PluginLoader.PluginAdapter)) {
            LOG.warn("Unable to read web manifest from plugin " + plugin + ": Plugin is not an instance of PluginAdapter.");
            return null;
        }
        String pluginClassName = ((PluginLoader.PluginAdapter)plugin).getPluginClassName();
        InputStream manifestStream = plugin.metadata().getClass().getResourceAsStream("/plugin." + pluginClassName + "." + manifestFilename);
        if (manifestStream != null) {
            try {
                return (ModuleManifest)this.objectMapper.readValue(manifestStream, ModuleManifest.class);
            }
            catch (IOException e) {
                LOG.warn("Unable to read web manifest from plugin " + plugin + ": ", (Throwable)e);
            }
        }
        LOG.debug("No valid web manifest found for plugin " + plugin);
        return null;
    }
}

