/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.ByteString;
import org.hbase.async.Bytes;
import org.hbase.async.FilterComparator;
import org.hbase.async.HBaseRpc;
import org.hbase.async.generated.ComparatorPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class BinaryComparator
extends FilterComparator {
    private static final byte[] NAME = Bytes.UTF8("org.apache.hadoop.hbase.filter.BinaryComparator");
    private static final byte CODE = 47;
    private final byte[] value;

    public BinaryComparator(byte[] value) {
        this.value = value;
    }

    public byte[] value() {
        return (byte[])this.value.clone();
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    ComparatorPB.Comparator toProtobuf() {
        ByteString byte_string = ComparatorPB.BinaryComparator.newBuilder().setComparable(ComparatorPB.ByteArrayComparable.newBuilder().setValue(Bytes.wrap(this.value))).build().toByteString();
        return super.toProtobuf(byte_string);
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        super.serializeOld(buf);
        buf.writeByte(47);
        HBaseRpc.writeByteArray(buf, this.value);
    }

    @Override
    int predictSerializedSize() {
        return 4 + this.value.length;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), Bytes.pretty(this.value));
    }
}

