/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.KeyValue;
import org.hbase.async.NonRecoverableException;
import org.hbase.async.RegionInfo;

public final class BrokenMetaException
extends NonRecoverableException {
    private final byte[] table;
    private static final long serialVersionUID = 1280222742L;

    BrokenMetaException(RegionInfo region, String msg) {
        super("Your .META. table seems broken for " + (region == null ? "(unknown table)" : region) + ".  " + msg);
        this.table = region.table();
    }

    BrokenMetaException(String msg, Exception cause) {
        super("Your .META. table seems broken.  " + msg, cause);
        this.table = null;
    }

    BrokenMetaException(String msg) {
        super("Your .META. table seems broken.  " + msg, null);
        this.table = null;
    }

    public byte[] table() {
        return this.table;
    }

    static BrokenMetaException badKV(RegionInfo region, String msg, KeyValue kv) {
        return new BrokenMetaException(region, "I found a row where " + msg + ".  KeyValue=" + kv);
    }
}

