/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.application.events;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hesperides.core.domain.events.queries.EventQueries;
import org.hesperides.core.domain.events.queries.EventView;
import org.hesperides.core.domain.modules.entities.Module;
import org.hesperides.core.domain.modules.queries.ModuleQueries;
import org.hesperides.core.domain.platforms.entities.Platform;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventsUseCases {
    private final EventQueries eventQueries;
    private final ModuleQueries moduleQueries;

    @Autowired
    public EventsUseCases(EventQueries eventQueries, ModuleQueries moduleQueries) {
        this.eventQueries = eventQueries;
        this.moduleQueries = moduleQueries;
    }

    public List<EventView> parseStreamNameAndGetEvents(String streamNameWithType, Integer page, Integer size) {
        String[] split = streamNameWithType.split("-", 2);
        String streamType = split[0];
        String streamName = split[1];
        switch (streamType) {
            case "module": {
                return this.moduleQueries.getModulesName().stream().filter(m -> StringUtils.contains((CharSequence)streamName, (CharSequence)m)).findFirst().flatMap(moduleKey -> EventsUseCases.parseModuleKey(streamName, moduleKey)).map(key -> this.getEvents((TemplateContainer.Key)key, page, size)).orElse(Collections.emptyList());
            }
            case "platform": {
                String[] streamNameSplited = streamName.split("-", 2);
                Platform.Key platformKey = new Platform.Key(streamNameSplited[0], streamNameSplited[1]);
                return this.getEvents(platformKey, page, size);
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Optional<Module.Key> parseModuleKey(String streamName, String moduleName) {
        String versionAndVersionType = streamName.replace(moduleName + "-", "");
        Matcher matcher = Pattern.compile("(.*)-([^-]+)$").matcher(versionAndVersionType);
        if (matcher.matches()) {
            return Optional.of(new Module.Key(moduleName, matcher.group(1), TemplateContainer.VersionType.fromMinimizedForm((String)matcher.group(2))));
        }
        return Optional.empty();
    }

    public List<EventView> getEvents(TemplateContainer.Key key, Integer page, Integer size) {
        return this.moduleQueries.getOptionalModuleId(key).map(moduleId -> this.eventQueries.getEvents(moduleId, page, size)).orElse(Collections.emptyList());
    }

    public List<EventView> getEvents(Platform.Key key, Integer page, Integer size) {
        return this.eventQueries.getEvents(key, page, size);
    }
}

