/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.application.modules;

import java.util.List;
import java.util.Optional;
import org.hesperides.core.domain.modules.commands.ModuleCommands;
import org.hesperides.core.domain.modules.entities.Module;
import org.hesperides.core.domain.modules.exceptions.DuplicateModuleException;
import org.hesperides.core.domain.modules.exceptions.ModuleNotFoundException;
import org.hesperides.core.domain.modules.queries.ModuleQueries;
import org.hesperides.core.domain.modules.queries.ModuleView;
import org.hesperides.core.domain.security.User;
import org.hesperides.core.domain.technos.entities.Techno;
import org.hesperides.core.domain.technos.exception.TechnoNotFoundException;
import org.hesperides.core.domain.technos.queries.TechnoQueries;
import org.hesperides.core.domain.templatecontainers.entities.Template;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.hesperides.core.domain.templatecontainers.queries.AbstractPropertyView;
import org.hesperides.core.domain.templatecontainers.queries.TemplateView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ModuleUseCases {
    private final ModuleCommands commands;
    private final ModuleQueries queries;
    private final TechnoQueries technoQueries;

    @Autowired
    public ModuleUseCases(ModuleCommands commands, ModuleQueries queries, TechnoQueries technoQueries) {
        this.commands = commands;
        this.queries = queries;
        this.technoQueries = technoQueries;
    }

    public String createWorkingCopy(Module module, User user) {
        if (this.queries.moduleExists(module.getKey())) {
            throw new DuplicateModuleException(module.getKey());
        }
        this.verifyTechnosExistence(module.getTechnos());
        return this.commands.createModule(module, user);
    }

    public String createWorkingCopyFrom(TemplateContainer.Key existingModuleKey, TemplateContainer.Key newModuleKey, User user) {
        if (this.queries.moduleExists(newModuleKey)) {
            throw new DuplicateModuleException(newModuleKey);
        }
        Optional optionalModuleView = this.queries.getOptionalModule(existingModuleKey);
        if (!optionalModuleView.isPresent()) {
            throw new ModuleNotFoundException(existingModuleKey);
        }
        Module existingModule = ((ModuleView)optionalModuleView.get()).toDomainInstance();
        Module newModule = new Module(newModuleKey, existingModule.getTemplates(), existingModule.getTechnos(), Long.valueOf(-1L));
        return this.commands.createModule(newModule, user);
    }

    public void updateModuleTechnos(Module module, User user) {
        Optional optionalModuleId = this.queries.getOptionalModuleId(module.getKey());
        if (!optionalModuleId.isPresent()) {
            throw new ModuleNotFoundException(module.getKey());
        }
        this.verifyTechnosExistence(module.getTechnos());
        this.commands.updateModuleTechnos((String)optionalModuleId.get(), module, user);
    }

    private void verifyTechnosExistence(List<Techno> technos) {
        if (technos != null) {
            for (Techno techno : technos) {
                if (this.technoQueries.technoExists(techno.getKey()).booleanValue()) continue;
                throw new TechnoNotFoundException(techno.getKey());
            }
        }
    }

    public void deleteModule(TemplateContainer.Key moduleKey, User user) {
        Optional optionalModuleId = this.queries.getOptionalModuleId(moduleKey);
        if (!optionalModuleId.isPresent()) {
            throw new ModuleNotFoundException(moduleKey);
        }
        this.commands.deleteModule((String)optionalModuleId.get(), user);
    }

    public void createTemplateInWorkingCopy(TemplateContainer.Key moduleKey, Template template, User user) {
        Optional optionalModuleId = this.queries.getOptionalModuleId(moduleKey);
        if (!optionalModuleId.isPresent()) {
            throw new ModuleNotFoundException(moduleKey);
        }
        this.commands.createTemplateInWorkingCopy((String)optionalModuleId.get(), template, user);
    }

    public void updateTemplateInWorkingCopy(TemplateContainer.Key moduleKey, Template template, User user) {
        Optional optionalModuleId = this.queries.getOptionalModuleId(moduleKey);
        if (!optionalModuleId.isPresent()) {
            throw new ModuleNotFoundException(moduleKey);
        }
        this.commands.updateTemplateInWorkingCopy((String)optionalModuleId.get(), template, user);
    }

    public void deleteTemplate(TemplateContainer.Key moduleKey, String templateName, User user) {
        Optional optionalModuleId = this.queries.getOptionalModuleId(moduleKey);
        if (!optionalModuleId.isPresent()) {
            throw new ModuleNotFoundException(moduleKey);
        }
        this.commands.deleteTemplate((String)optionalModuleId.get(), templateName, user);
    }

    public Optional<ModuleView> getModule(TemplateContainer.Key moduleKey) {
        return this.queries.getOptionalModule(moduleKey);
    }

    public Optional<ModuleView> getModule(String moduleId) {
        return this.queries.getOptionalModule(moduleId);
    }

    public List<String> getModulesName() {
        return this.queries.getModulesName();
    }

    public List<String> getModuleVersions(String moduleName) {
        return this.queries.getModuleVersions(moduleName);
    }

    public List<String> getModuleTypes(String moduleName, String moduleVersion) {
        return this.queries.getModuleTypes(moduleName, moduleVersion);
    }

    public Optional<TemplateView> getTemplate(TemplateContainer.Key moduleKey, String templateName) {
        return this.queries.getTemplate(moduleKey, templateName);
    }

    public List<ModuleView> search(String input) {
        return this.queries.search(input);
    }

    public List<TemplateView> getTemplates(TemplateContainer.Key moduleKey) {
        return this.queries.getTemplates(moduleKey);
    }

    public ModuleView createRelease(String moduleName, String moduleVersion, String releaseVersion, User user) {
        String version = StringUtils.isEmpty((Object)releaseVersion) ? moduleVersion : releaseVersion;
        Module.Key newModuleKey = new Module.Key(moduleName, version, TemplateContainer.VersionType.release);
        if (this.queries.moduleExists((TemplateContainer.Key)newModuleKey)) {
            throw new DuplicateModuleException((TemplateContainer.Key)newModuleKey);
        }
        Module.Key existingModuleKey = new Module.Key(moduleName, moduleVersion, TemplateContainer.VersionType.workingcopy);
        Optional optionalModuleView = this.queries.getOptionalModule((TemplateContainer.Key)existingModuleKey);
        if (!optionalModuleView.isPresent()) {
            throw new ModuleNotFoundException((TemplateContainer.Key)existingModuleKey);
        }
        Module existingModule = ((ModuleView)optionalModuleView.get()).toDomainInstance();
        Module moduleRelease = new Module((TemplateContainer.Key)newModuleKey, existingModule.getTemplates(), existingModule.getTechnos(), Long.valueOf(-1L));
        this.commands.createModule(moduleRelease, user);
        return (ModuleView)this.queries.getOptionalModule((TemplateContainer.Key)newModuleKey).get();
    }

    public List<AbstractPropertyView> getProperties(TemplateContainer.Key moduleKey) {
        if (!this.queries.moduleExists(moduleKey)) {
            throw new ModuleNotFoundException(moduleKey);
        }
        return this.queries.getProperties(moduleKey);
    }
}

