/*
 * Decompiled with CFR 0.152.
 */
package org.hesperides.core.application.technos;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hesperides.core.domain.modules.exceptions.DuplicateModuleException;
import org.hesperides.core.domain.modules.exceptions.ModuleNotFoundException;
import org.hesperides.core.domain.security.User;
import org.hesperides.core.domain.technos.commands.TechnoCommands;
import org.hesperides.core.domain.technos.entities.Techno;
import org.hesperides.core.domain.technos.exception.DuplicateTechnoException;
import org.hesperides.core.domain.technos.exception.TechnoNotFoundException;
import org.hesperides.core.domain.technos.queries.TechnoQueries;
import org.hesperides.core.domain.technos.queries.TechnoView;
import org.hesperides.core.domain.templatecontainers.entities.Template;
import org.hesperides.core.domain.templatecontainers.entities.TemplateContainer;
import org.hesperides.core.domain.templatecontainers.queries.AbstractPropertyView;
import org.hesperides.core.domain.templatecontainers.queries.TemplateView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TechnoUseCases {
    private final TechnoCommands commands;
    private final TechnoQueries queries;

    @Autowired
    public TechnoUseCases(TechnoCommands commands, TechnoQueries queries) {
        this.commands = commands;
        this.queries = queries;
    }

    public void addTemplate(TemplateContainer.Key technoKey, Template template, User user) {
        String technoId = this.queries.getOptionalTechnoId(technoKey).orElseGet(() -> {
            Techno techno = new Techno(technoKey, Collections.emptyList());
            return this.commands.createTechno(techno, user);
        });
        this.commands.addTemplate(technoId, template, user);
    }

    public void deleteTechno(TemplateContainer.Key technoKey, User user) {
        Optional technoId = this.queries.getOptionalTechnoId(technoKey);
        if (!technoId.isPresent()) {
            throw new TechnoNotFoundException(technoKey);
        }
        this.commands.deleteTechno((String)technoId.get(), user);
    }

    public void updateTemplateInWorkingCopy(TemplateContainer.Key technoKey, Template template, User user) {
        Optional technoId = this.queries.getOptionalTechnoId(technoKey);
        if (!technoId.isPresent()) {
            throw new TechnoNotFoundException(technoKey);
        }
        this.commands.updateTemplate((String)technoId.get(), template, user);
    }

    public void deleteTemplate(TemplateContainer.Key technoKey, String templateName, User user) {
        Optional technoId = this.queries.getOptionalTechnoId(technoKey);
        if (!technoId.isPresent()) {
            throw new TechnoNotFoundException(technoKey);
        }
        this.commands.deleteTemplate((String)technoId.get(), templateName, user);
    }

    public Optional<TemplateView> getTemplate(TemplateContainer.Key technoKey, String templateName) {
        if (!this.queries.technoExists(technoKey).booleanValue()) {
            throw new TechnoNotFoundException(technoKey);
        }
        return this.queries.getTemplate(technoKey, templateName);
    }

    public List<TemplateView> getTemplates(TemplateContainer.Key technoKey) {
        List templates = Collections.emptyList();
        if (this.queries.technoExists(technoKey).booleanValue()) {
            templates = this.queries.getTemplates(technoKey);
        }
        return templates;
    }

    public TechnoView releaseTechno(TemplateContainer.Key existingTechnoKey, User user) {
        Techno.Key newTechnoKey = new Techno.Key(existingTechnoKey.getName(), existingTechnoKey.getVersion(), TemplateContainer.VersionType.release);
        if (this.queries.technoExists((TemplateContainer.Key)newTechnoKey).booleanValue()) {
            throw new DuplicateTechnoException((TemplateContainer.Key)newTechnoKey);
        }
        Optional optionalTechnoView = this.queries.getOptionalTechno(existingTechnoKey);
        if (!optionalTechnoView.isPresent()) {
            throw new TechnoNotFoundException(existingTechnoKey);
        }
        Techno existingTechno = ((TechnoView)optionalTechnoView.get()).toDomainInstance();
        Techno technoRelease = new Techno((TemplateContainer.Key)newTechnoKey, existingTechno.getTemplates());
        this.commands.createTechno(technoRelease, user);
        return (TechnoView)this.queries.getOptionalTechno((TemplateContainer.Key)newTechnoKey).get();
    }

    public Optional<TechnoView> getTechno(TemplateContainer.Key technoKey) {
        return this.queries.getOptionalTechno(technoKey);
    }

    public List<TechnoView> search(String input) {
        return this.queries.search(input);
    }

    public TechnoView createWorkingCopyFrom(TemplateContainer.Key existingTechnoKey, TemplateContainer.Key newTechnoKey, User user) {
        if (this.queries.technoExists(newTechnoKey).booleanValue()) {
            throw new DuplicateModuleException(newTechnoKey);
        }
        Optional optionalTechnoView = this.queries.getOptionalTechno(existingTechnoKey);
        if (!optionalTechnoView.isPresent()) {
            throw new ModuleNotFoundException(existingTechnoKey);
        }
        Techno existingTechno = ((TechnoView)optionalTechnoView.get()).toDomainInstance();
        Techno newTechno = new Techno(newTechnoKey, existingTechno.getTemplates());
        this.commands.createTechno(newTechno, user);
        return (TechnoView)this.queries.getOptionalTechno(newTechnoKey).get();
    }

    public List<AbstractPropertyView> getProperties(TemplateContainer.Key technoKey) {
        List properties = Collections.emptyList();
        if (this.queries.technoExists(technoKey).booleanValue()) {
            properties = this.queries.getProperties(technoKey);
        }
        return properties;
    }
}

