/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.metadata.ParameterDescriptor;
import org.hibernate.validator.internal.engine.valuehandling.UnwrapMode;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.aggregated.ParameterMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ReturnValueMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ValidatableParametersMetaData;
import org.hibernate.validator.internal.metadata.aggregated.rule.MethodConfigurationRule;
import org.hibernate.validator.internal.metadata.aggregated.rule.OverridingMethodMustNotAlterParameterConstraints;
import org.hibernate.validator.internal.metadata.aggregated.rule.ParallelMethodsMustNotDefineGroupConversionForCascadedReturnValue;
import org.hibernate.validator.internal.metadata.aggregated.rule.ParallelMethodsMustNotDefineParameterConstraints;
import org.hibernate.validator.internal.metadata.aggregated.rule.ReturnValueMayOnlyBeMarkedOnceAsCascadedPerHierarchyLine;
import org.hibernate.validator.internal.metadata.aggregated.rule.VoidMethodsMustNotBeReturnValueConstrained;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ExecutableDescriptorImpl;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ExecutableMetaData
extends AbstractConstraintMetaData {
    private static final Log log = LoggerFactory.make();
    private final Class<?>[] parameterTypes;
    private final List<ParameterMetaData> parameterMetaDataList;
    private final Set<MetaConstraint<?>> crossParameterConstraints;
    private final boolean isGetter;
    private final String identifier;
    private final ReturnValueMetaData returnValueMetaData;

    private ExecutableMetaData(String name, Type returnType, Class<?>[] parameterTypes, ElementKind kind, Set<MetaConstraint<?>> returnValueConstraints, List<ParameterMetaData> parameterMetaData, Set<MetaConstraint<?>> crossParameterConstraints, Set<MetaConstraint<?>> typeArgumentsConstraints, Map<Class<?>, Class<?>> returnValueGroupConversions, boolean isCascading, boolean isConstrained, boolean isGetter, UnwrapMode unwrapMode) {
        super(name, returnType, returnValueConstraints, kind, isCascading, isConstrained, unwrapMode);
        this.parameterTypes = parameterTypes;
        this.parameterMetaDataList = Collections.unmodifiableList(parameterMetaData);
        this.crossParameterConstraints = Collections.unmodifiableSet(crossParameterConstraints);
        this.identifier = name + Arrays.toString(parameterTypes);
        this.returnValueMetaData = new ReturnValueMetaData(returnType, returnValueConstraints, typeArgumentsConstraints, isCascading, returnValueGroupConversions, unwrapMode);
        this.isGetter = isGetter;
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaDataList.size() - 1) {
            throw log.getInvalidExecutableParameterIndexException(ExecutableElement.getExecutableAsString(this.getType().toString() + "#" + this.getName(), this.parameterTypes), this.parameterTypes.length);
        }
        return this.parameterMetaDataList.get(parameterIndex);
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Set<MetaConstraint<?>> getCrossParameterConstraints() {
        return this.crossParameterConstraints;
    }

    public ValidatableParametersMetaData getValidatableParametersMetaData() {
        HashSet cascadedParameters = CollectionHelper.newHashSet();
        for (ParameterMetaData parameterMetaData : this.parameterMetaDataList) {
            if (!parameterMetaData.isCascading()) continue;
            cascadedParameters.add(parameterMetaData);
        }
        return new ValidatableParametersMetaData(cascadedParameters);
    }

    public ReturnValueMetaData getReturnValueMetaData() {
        return this.returnValueMetaData;
    }

    @Override
    public ExecutableDescriptorImpl asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new ExecutableDescriptorImpl(this.getType(), this.getName(), this.asDescriptors(this.getCrossParameterConstraints()), this.returnValueMetaData.asDescriptor(defaultGroupSequenceRedefined, defaultGroupSequence), this.parametersAsDescriptors(defaultGroupSequenceRedefined, defaultGroupSequence), defaultGroupSequenceRedefined, this.isGetter, defaultGroupSequence);
    }

    private List<ParameterDescriptor> parametersAsDescriptors(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        ArrayList<ParameterDescriptor> parameterDescriptorList = CollectionHelper.newArrayList();
        for (ParameterMetaData parameterMetaData : this.parameterMetaDataList) {
            parameterDescriptorList.add(parameterMetaData.asDescriptor(defaultGroupSequenceRedefined, defaultGroupSequence));
        }
        return parameterDescriptorList;
    }

    @Override
    public String toString() {
        StringBuilder parameterBuilder = new StringBuilder();
        for (Class<?> oneParameterType : this.getParameterTypes()) {
            parameterBuilder.append(oneParameterType.getSimpleName());
            parameterBuilder.append(", ");
        }
        String parameters = parameterBuilder.length() > 0 ? parameterBuilder.substring(0, parameterBuilder.length() - 2) : parameterBuilder.toString();
        return "ExecutableMetaData [executable=" + this.getType() + " " + this.getName() + "(" + parameters + "), isCascading=" + this.isCascading() + ", isConstrained=" + this.isConstrained() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutableMetaData other = (ExecutableMetaData)obj;
        return Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    public static class Builder
    extends MetaDataBuilder {
        private static final Set<MethodConfigurationRule> rules = Collections.unmodifiableSet(CollectionHelper.asSet(new OverridingMethodMustNotAlterParameterConstraints(), new ParallelMethodsMustNotDefineParameterConstraints(), new VoidMethodsMustNotBeReturnValueConstrained(), new ReturnValueMayOnlyBeMarkedOnceAsCascadedPerHierarchyLine(), new ParallelMethodsMustNotDefineGroupConversionForCascadedReturnValue()));
        private final ConstrainedElement.ConstrainedElementKind kind;
        private final Set<ConstrainedExecutable> constrainedExecutables = CollectionHelper.newHashSet();
        private ExecutableElement executable;
        private final Set<MetaConstraint<?>> crossParameterConstraints = CollectionHelper.newHashSet();
        private final Set<MetaConstraint<?>> typeArgumentsConstraints = CollectionHelper.newHashSet();
        private boolean isConstrained = false;
        private final Map<Class<?>, ConstrainedExecutable> executablesByDeclaringType = CollectionHelper.newHashMap();
        private final ExecutableHelper executableHelper;

        public Builder(Class<?> beanClass, ConstrainedExecutable constrainedExecutable, ConstraintHelper constraintHelper, ExecutableHelper executableHelper) {
            super(beanClass, constraintHelper);
            this.executableHelper = executableHelper;
            this.kind = constrainedExecutable.getKind();
            this.executable = constrainedExecutable.getExecutable();
            this.add(constrainedExecutable);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (this.kind != constrainedElement.getKind()) {
                return false;
            }
            ExecutableElement executableElement = ((ConstrainedExecutable)constrainedElement).getExecutable();
            return this.executable.equals(executableElement) || this.executableHelper.overrides(this.executable, executableElement) || this.executableHelper.overrides(executableElement, this.executable);
        }

        @Override
        public void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            ConstrainedExecutable constrainedExecutable = (ConstrainedExecutable)constrainedElement;
            this.constrainedExecutables.add(constrainedExecutable);
            this.isConstrained = this.isConstrained || constrainedExecutable.isConstrained();
            this.crossParameterConstraints.addAll(constrainedExecutable.getCrossParameterConstraints());
            this.typeArgumentsConstraints.addAll(constrainedExecutable.getTypeArgumentsConstraints());
            this.addToExecutablesByDeclaringType(constrainedExecutable);
            if (this.executable != null && this.executableHelper.overrides(constrainedExecutable.getExecutable(), this.executable)) {
                this.executable = constrainedExecutable.getExecutable();
            }
        }

        private void addToExecutablesByDeclaringType(ConstrainedExecutable executable) {
            Class<?> beanClass = executable.getLocation().getDeclaringClass();
            ConstrainedExecutable mergedExecutable = this.executablesByDeclaringType.get(beanClass);
            mergedExecutable = mergedExecutable != null ? mergedExecutable.merge(executable) : executable;
            this.executablesByDeclaringType.put(beanClass, mergedExecutable.merge(executable));
        }

        @Override
        public ExecutableMetaData build() {
            this.assertCorrectnessOfConfiguration();
            return new ExecutableMetaData(this.executable.getSimpleName(), ReflectionHelper.typeOf(this.executable.getMember()), this.executable.getParameterTypes(), this.kind == ConstrainedElement.ConstrainedElementKind.CONSTRUCTOR ? ElementKind.CONSTRUCTOR : ElementKind.METHOD, this.adaptOriginsAndImplicitGroups(this.getConstraints()), this.findParameterMetaData(), this.adaptOriginsAndImplicitGroups(this.crossParameterConstraints), this.typeArgumentsConstraints, this.getGroupConversions(), this.isCascading(), this.isConstrained, this.executable.isGetterMethod(), this.unwrapMode());
        }

        private List<ParameterMetaData> findParameterMetaData() {
            ArrayList<ParameterMetaData.Builder> parameterBuilders = null;
            for (ConstrainedExecutable oneExecutable : this.constrainedExecutables) {
                if (parameterBuilders == null) {
                    parameterBuilders = CollectionHelper.newArrayList();
                    for (ConstrainedParameter oneParameter : oneExecutable.getAllParameterMetaData()) {
                        parameterBuilders.add(new ParameterMetaData.Builder(this.executable.getMember().getDeclaringClass(), oneParameter, this.constraintHelper));
                    }
                    continue;
                }
                int i = 0;
                for (ConstrainedParameter oneParameter : oneExecutable.getAllParameterMetaData()) {
                    ((ParameterMetaData.Builder)parameterBuilders.get(i)).add(oneParameter);
                    ++i;
                }
            }
            ArrayList<ParameterMetaData> parameterMetaDatas = CollectionHelper.newArrayList();
            for (ParameterMetaData.Builder oneBuilder : parameterBuilders) {
                parameterMetaDatas.add(oneBuilder.build());
            }
            return parameterMetaDatas;
        }

        private void assertCorrectnessOfConfiguration() {
            for (Map.Entry<Class<?>, ConstrainedExecutable> entry : this.executablesByDeclaringType.entrySet()) {
                for (Map.Entry<Class<?>, ConstrainedExecutable> otherEntry : this.executablesByDeclaringType.entrySet()) {
                    for (MethodConfigurationRule rule : rules) {
                        rule.apply(entry.getValue(), otherEntry.getValue());
                    }
                }
            }
        }
    }
}

