/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spring.web;

import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import org.jboss.resteasy.spring.web.ResponseStatusContainerResponseFilter;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
public class ResponseStatusFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        ResponseStatus responseStatus = resourceInfo.getResourceMethod().getAnnotation(ResponseStatus.class);
        if (responseStatus == null) {
            return;
        }
        HttpStatus httpStatus = responseStatus.code();
        if (httpStatus == HttpStatus.INTERNAL_SERVER_ERROR) {
            httpStatus = responseStatus.value();
        }
        context.register((Object)new ResponseStatusContainerResponseFilter(Void.TYPE.equals(resourceInfo.getResourceMethod().getReturnType()) ? 204 : 200, httpStatus.value()));
    }
}

