/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.api.integration.model;

import java.util.Date;
import java.util.Map;
import org.jbpm.persistence.api.integration.InstanceView;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.runtime.process.ProcessInstance;

public class ProcessInstanceView
implements InstanceView<ProcessInstance> {
    private static final long serialVersionUID = 8232478719589705492L;
    private String compositeId;
    private Long id;
    private String processId;
    private String processName;
    private String processVersion;
    private Integer state;
    private String containerId;
    private String initiator;
    private Date date;
    private String processInstanceDescription;
    private String correlationKey;
    private Long parentId;
    private Map<String, Object> variables;
    private transient ProcessInstance source;

    public ProcessInstanceView() {
    }

    public ProcessInstanceView(ProcessInstance source) {
        this.source = source;
        this.id = source.getId();
    }

    @Override
    public String getCompositeId() {
        return this.compositeId;
    }

    public void setCompositeId(String compositeId) {
        this.compositeId = compositeId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(String processVersion) {
        this.processVersion = processVersion;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getProcessInstanceDescription() {
        return this.processInstanceDescription;
    }

    public void setProcessInstanceDescription(String processInstanceDescription) {
        this.processInstanceDescription = processInstanceDescription;
    }

    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public String toString() {
        return "ProcessInstance{id=" + this.id + ", processId='" + this.processId + '\'' + ", processName='" + this.processName + '\'' + ", state=" + this.state + ", containerId='" + this.containerId + '\'' + ", correlationKey='" + this.correlationKey + '\'' + '}';
    }

    @Override
    public ProcessInstance getSource() {
        return this.source;
    }

    @Override
    public void copyFromSource() {
        this.compositeId = System.getProperty("org.kie.server.id", "") + "_" + this.source.getId();
        this.containerId = ((WorkflowProcessInstance)this.source).getDeploymentId();
        this.correlationKey = ((WorkflowProcessInstanceImpl)this.source).getCorrelationKey();
        this.date = new Date();
        this.id = this.source.getId();
        this.initiator = (String)((WorkflowProcessInstanceImpl)this.source).getVariable("initiator");
        this.parentId = this.source.getParentProcessInstanceId();
        this.processId = this.source.getProcessId();
        this.processInstanceDescription = ((WorkflowProcessInstanceImpl)this.source).getDescription();
        this.processName = this.source.getProcessName();
        this.processVersion = this.source.getProcess().getVersion();
        this.state = this.source.getState();
        this.variables = ((WorkflowProcessInstanceImpl)this.source).getVariables();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceView other = (ProcessInstanceView)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

