/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public final class ArgsUtil {
    public static IRubyObject[] convertToJavaArray(IRubyObject value2) {
        if (value2 == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (value2 instanceof RubyArray) {
            return ((RubyArray)value2).toJavaArrayMaybeUnsafe();
        }
        return new IRubyObject[]{value2};
    }

    public static RubyArray convertToRubyArray(Ruby runtime2, IRubyObject value2, boolean coerce2) {
        if (value2 == null) {
            return RubyArray.newEmptyArray(runtime2);
        }
        if (coerce2) {
            return ArgsUtil.convertToRubyArrayWithCoerce(runtime2, value2);
        }
        return RubyArray.newArrayLight(runtime2, value2);
    }

    public static RubyArray convertToRubyArrayWithCoerce(Ruby runtime2, IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return (RubyArray)value2;
        }
        IRubyObject newValue = TypeConverter.convertToType(value2, runtime2.getArray(), "to_ary", false);
        if (newValue.isNil()) {
            return RubyArray.newArrayLight(runtime2, value2);
        }
        if (!(newValue instanceof RubyArray)) {
            throw runtime2.newTypeError(newValue.getMetaClass() + "#" + "to_ary" + " should return Array");
        }
        return (RubyArray)newValue;
    }

    public static IRubyObject[] popArray(IRubyObject[] array) {
        if (array == null || array.length == 0) {
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] newArray = new IRubyObject[array.length - 1];
        System.arraycopy(array, 1, newArray, 0, array.length - 1);
        return newArray;
    }

    public static int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }
}

