/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.ruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.yecht.Data;
import org.yecht.MapStyle;
import org.yecht.Node;
import org.yecht.SeqStyle;

public class GenericResolver {
    @JRubyMethod
    public static IRubyObject node_import(IRubyObject self, IRubyObject node) {
        Ruby runtime2 = self.getRuntime();
        ThreadContext ctx = runtime2.getCurrentContext();
        Node n = (Node)node.dataGetStructChecked();
        IRubyObject t = runtime2.getNil();
        Extra x = (Extra)self.dataGetStruct();
        if (n.type_id != null) {
            t = runtime2.newString(n.type_id);
        }
        switch (n.kind) {
            case Str: {
                return x.scalar(t, n, ctx);
            }
            case Seq: {
                return x.sequence(t, n, ctx);
            }
            case Map: {
                return x.mapping(t, n, ctx);
            }
        }
        return runtime2.getNil();
    }

    public static class Extra {
        public IRubyObject quote1;
        public IRubyObject quote2;
        public IRubyObject fold;
        public IRubyObject literal;
        public IRubyObject plain;
        public IRubyObject map;
        public IRubyObject seq;
        public IRubyObject inline;
        public IRubyObject Scalar;
        public IRubyObject Seq;
        public IRubyObject Map;
        public Ruby runtime;
        private final CallSite newScalarAdapter = MethodIndex.getFunctionalCallSite("new");
        private final CallSite newSeqAdapter = MethodIndex.getFunctionalCallSite("new");
        private final CallSite newMapAdapter = MethodIndex.getFunctionalCallSite("new");

        public Extra(Ruby runtime2) {
            this.quote1 = runtime2.newSymbol("quote1");
            this.quote2 = runtime2.newSymbol("quote2");
            this.fold = runtime2.newSymbol("fold");
            this.literal = runtime2.newSymbol("literal");
            this.plain = runtime2.newSymbol("plain");
            this.map = runtime2.newSymbol("map");
            this.seq = runtime2.newSymbol("seq");
            this.inline = runtime2.newSymbol("inline");
            this.Scalar = ((RubyModule)runtime2.getModule("YAML").getConstant("Yecht")).getConstant("Scalar");
            this.Seq = ((RubyModule)runtime2.getModule("YAML").getConstant("Yecht")).getConstant("Seq");
            this.Map = ((RubyModule)runtime2.getModule("YAML").getConstant("Yecht")).getConstant("Map");
            this.runtime = runtime2;
        }

        public IRubyObject scalar(IRubyObject t, Node n, ThreadContext ctx) {
            Data.Str dd = (Data.Str)n.data;
            RubyString v = RubyString.newStringShared(this.runtime, dd.ptr.buffer, dd.ptr.start, dd.len);
            IRubyObject style = this.runtime.getNil();
            switch (dd.style) {
                case OneQuote: {
                    style = this.quote1;
                    break;
                }
                case TwoQuote: {
                    style = this.quote2;
                    break;
                }
                case Fold: {
                    style = this.fold;
                    break;
                }
                case Literal: {
                    style = this.literal;
                    break;
                }
                case Plain: {
                    style = this.plain;
                }
            }
            return this.newScalarAdapter.call(ctx, this.Scalar, this.Scalar, t, (IRubyObject)v, style);
        }

        public IRubyObject sequence(IRubyObject t, Node n, ThreadContext ctx) {
            Data.Seq ds = (Data.Seq)n.data;
            Object[] items = ds.items;
            RubyArray v = RubyArray.newArray(this.runtime, ds.idx);
            for (int i2 = 0; i2 < ds.idx; ++i2) {
                v.store(i2, (IRubyObject)items[i2]);
            }
            IRubyObject style = this.runtime.getNil();
            if (((Data.Seq)n.data).style == SeqStyle.Inline) {
                style = this.inline;
            }
            IRubyObject obj = this.newSeqAdapter.call(ctx, this.Seq, this.Seq, t, (IRubyObject)v, style);
            ((RubyObject)obj).fastSetInstanceVariable("@kind", this.seq);
            return obj;
        }

        public IRubyObject mapping(IRubyObject t, Node n, ThreadContext ctx) {
            Data.Map dm = (Data.Map)n.data;
            Object[] keys2 = dm.keys;
            Object[] vals = dm.values;
            RubyHash v = RubyHash.newHash(this.runtime);
            for (int i2 = 0; i2 < dm.idx; ++i2) {
                IRubyObject k3 = (IRubyObject)keys2[i2];
                IRubyObject v3 = (IRubyObject)vals[i2];
                if (null == v3) {
                    v3 = this.runtime.getNil();
                }
                v.fastASet(k3, v3);
            }
            IRubyObject style = this.runtime.getNil();
            if (((Data.Map)n.data).style == MapStyle.Inline) {
                style = this.inline;
            }
            IRubyObject obj = this.newMapAdapter.call(ctx, this.Map, this.Map, t, (IRubyObject)v, style);
            ((RubyObject)obj).fastSetInstanceVariable("@kind", this.map);
            return obj;
        }
    }
}

