/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.jruby.CompatVersion;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.util.CodegenUtils;

@SupportedAnnotationTypes(value={"org.jruby.anno.JRubyMethod"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class AnnotationBinder
extends AbstractProcessor {
    public static final String POPULATOR_SUFFIX = "$POPULATOR";
    private static final Logger LOG = Logger.getLogger("AnnotationBinder");
    public static final String SRC_GEN_DIR = "target/generated-sources/org/jruby/gen/";
    private final List<CharSequence> classNames = new ArrayList<CharSequence>();
    private PrintStream out;
    private static final boolean DEBUG = false;

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        for (TypeElement element : ElementFilter.typesIn(roundEnvironment.getRootElements())) {
            this.processType(element);
        }
        try {
            FileWriter fw = new FileWriter("target/generated-sources/annotated_classes.txt");
            for (CharSequence name2 : this.classNames) {
                fw.write(name2.toString());
                fw.write(10);
            }
            fw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void processType(TypeElement cd) {
        for (TypeElement innerType : ElementFilter.typesIn(cd.getEnclosedElements())) {
            this.processType(innerType);
        }
        try {
            ExecutableElement decl;
            String qualifiedName = cd.getQualifiedName().toString().replace('.', '$');
            if (!qualifiedName.contains("org$jruby")) {
                return;
            }
            ByteArrayOutputStream bytes2 = new ByteArrayOutputStream(1024);
            this.out = new PrintStream(bytes2);
            this.out.println("/* THIS FILE IS GENERATED. DO NOT EDIT */");
            this.out.println("package org.jruby.gen;");
            this.out.println("import org.jruby.Ruby;");
            this.out.println("import org.jruby.RubyModule;");
            this.out.println("import org.jruby.RubyClass;");
            this.out.println("import org.jruby.CompatVersion;");
            this.out.println("import org.jruby.anno.TypePopulator;");
            this.out.println("import org.jruby.internal.runtime.methods.CallConfiguration;");
            this.out.println("import org.jruby.internal.runtime.methods.JavaMethod;");
            this.out.println("import org.jruby.internal.runtime.methods.DynamicMethod;");
            this.out.println("import org.jruby.runtime.Arity;");
            this.out.println("import org.jruby.runtime.Visibility;");
            this.out.println("import org.jruby.compiler.ASTInspector;");
            this.out.println("import java.util.Arrays;");
            this.out.println("import java.util.List;");
            this.out.println("import javax.annotation.Generated;");
            this.out.println("@Generated(\"org.jruby.anno.AnnotationBinder\")");
            this.out.println("public class " + qualifiedName + POPULATOR_SUFFIX + " extends TypePopulator {");
            this.out.println("    public void populate(RubyModule cls, Class clazz) {");
            boolean hasAnno = false;
            boolean hasMeta = false;
            boolean hasModule = false;
            boolean hasCompat = false;
            for (ExecutableElement method2 : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                hasAnno = true;
                hasMeta |= anno.meta();
                hasModule |= anno.module();
                hasCompat |= anno.compat() != CompatVersion.BOTH;
            }
            if (!hasAnno) {
                return;
            }
            this.out.println("        JavaMethod javaMethod;");
            this.out.println("        DynamicMethod moduleMethod;");
            if (hasMeta || hasModule) {
                this.out.println("        RubyClass singletonClass = cls.getSingletonClass();");
            }
            if (hasCompat) {
                this.out.println("        CompatVersion compatVersion = cls.getRuntime().getInstanceConfig().getCompatVersion();");
            }
            this.out.println("        Ruby runtime = cls.getRuntime();");
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods1_8 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods1_8 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods1_9 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods1_9 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods2_0 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods2_0 = new HashMap<CharSequence, List<ExecutableElement>>();
            HashSet<String> frameAwareMethods = new HashSet<String>();
            HashSet<String> scopeAwareMethods = new HashSet<String>();
            int methodCount = 0;
            for (ExecutableElement executableElement : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                void var24_51;
                JRubyMethod anno = executableElement.getAnnotation(JRubyMethod.class);
                if (anno == null) continue;
                ++methodCount;
                if (executableElement.getThrownTypes().size() != 0) {
                    System.err.print("Method " + cd.toString() + "." + executableElement.toString() + " should not throw exceptions: ");
                    boolean bl = false;
                    for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
                        boolean bl2;
                        if (bl2) {
                            System.err.print(", ");
                        }
                        System.err.print(typeMirror);
                        bl2 = true;
                    }
                    System.err.print("\n");
                }
                Name name2 = anno.name().length == 0 ? executableElement.getSimpleName() : anno.name()[0];
                Object var24_54 = null;
                if (executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    if (anno.compat() == CompatVersion.RUBY1_8) {
                        HashMap<CharSequence, List<ExecutableElement>> hashMap = staticAnnotatedMethods1_8;
                    } else if (anno.compat() == CompatVersion.RUBY1_9) {
                        HashMap<CharSequence, List<ExecutableElement>> hashMap = staticAnnotatedMethods1_9;
                    } else if (anno.compat() == CompatVersion.RUBY2_0) {
                        HashMap<CharSequence, List<ExecutableElement>> hashMap = staticAnnotatedMethods2_0;
                    } else {
                        HashMap<CharSequence, List<ExecutableElement>> hashMap = staticAnnotatedMethods;
                    }
                } else if (anno.compat() == CompatVersion.RUBY1_8) {
                    HashMap<CharSequence, List<ExecutableElement>> hashMap = annotatedMethods1_8;
                } else if (anno.compat() == CompatVersion.RUBY1_9) {
                    HashMap<CharSequence, List<ExecutableElement>> hashMap = annotatedMethods1_9;
                } else if (anno.compat() == CompatVersion.RUBY2_0) {
                    HashMap<CharSequence, List<ExecutableElement>> hashMap = annotatedMethods2_0;
                } else {
                    HashMap<CharSequence, List<ExecutableElement>> hashMap = annotatedMethods;
                }
                ArrayList<ExecutableElement> methodDescs = (ArrayList<ExecutableElement>)var24_51.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<ExecutableElement>();
                    var24_51.put(name2, methodDescs);
                }
                methodDescs.add(executableElement);
                boolean frame = false;
                boolean scope = false;
                if (anno.frame()) {
                    frame = true;
                }
                if (anno.scope()) {
                    scope = true;
                }
                for (FrameField field2 : anno.reads()) {
                    frame |= field2.needsFrame();
                    scope |= field2.needsScope();
                }
                for (FrameField field2 : anno.writes()) {
                    frame |= field2.needsFrame();
                    scope |= field2.needsScope();
                }
                if (frame) {
                    AnnotationBinder.addMethodNamesToSet(frameAwareMethods, anno, executableElement.getSimpleName().toString());
                }
                if (!scope) continue;
                AnnotationBinder.addMethodNamesToSet(scopeAwareMethods, anno, executableElement.getSimpleName().toString());
            }
            if (methodCount == 0) {
                return;
            }
            this.classNames.add(this.getActualQualifiedName(cd));
            this.processMethodDeclarations(staticAnnotatedMethods);
            for (Map.Entry entry : staticAnnotatedMethods.entrySet()) {
                decl = (ExecutableElement)((List)entry.getValue()).get(0);
                if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
            }
            if (!staticAnnotatedMethods1_8.isEmpty()) {
                this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(staticAnnotatedMethods1_8);
                for (Map.Entry entry : staticAnnotatedMethods1_8.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.out.println("        }");
            }
            if (!staticAnnotatedMethods1_9.isEmpty()) {
                this.out.println("        if (compatVersion.is1_9() || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(staticAnnotatedMethods1_9);
                for (Map.Entry entry : staticAnnotatedMethods1_9.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.out.println("        }");
            }
            if (!staticAnnotatedMethods2_0.isEmpty()) {
                this.out.println("        if (compatVersion.is2_0() || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(staticAnnotatedMethods2_0);
                for (Map.Entry entry : staticAnnotatedMethods2_0.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.out.println("        }");
            }
            this.processMethodDeclarations(annotatedMethods);
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                decl = (ExecutableElement)((List)entry.getValue()).get(0);
                if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
            }
            if (!annotatedMethods1_8.isEmpty()) {
                this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(annotatedMethods1_8);
                for (Map.Entry entry : annotatedMethods1_8.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.out.println("        }");
            }
            if (!annotatedMethods1_9.isEmpty()) {
                this.out.println("        if (compatVersion.is1_9() || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(annotatedMethods1_9);
                for (Map.Entry entry : annotatedMethods1_9.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.out.println("        }");
            }
            if (!annotatedMethods2_0.isEmpty()) {
                this.out.println("        if (compatVersion.is2_0() || compatVersion == CompatVersion.BOTH) {");
                this.processMethodDeclarations(annotatedMethods2_0);
                for (Map.Entry entry : annotatedMethods2_0.entrySet()) {
                    decl = (ExecutableElement)((List)entry.getValue()).get(0);
                    if (decl.getAnnotation(JRubyMethod.class).omit()) continue;
                    this.addCoreMethodMapping((CharSequence)entry.getKey(), decl, this.out);
                }
                this.out.println("        }");
            }
            this.out.println("    }");
            this.out.println("    static {");
            if (!frameAwareMethods.isEmpty()) {
                StringBuffer frameMethodsString = new StringBuffer();
                boolean bl = true;
                for (CharSequence charSequence : frameAwareMethods) {
                    boolean bl3;
                    if (!bl3) {
                        frameMethodsString.append(',');
                    }
                    bl3 = false;
                    frameMethodsString.append('\"').append(charSequence).append('\"');
                }
                this.out.println("        ASTInspector.addFrameAwareMethods(" + frameMethodsString + ");");
            }
            if (!scopeAwareMethods.isEmpty()) {
                StringBuffer scopeMethodsString = new StringBuffer();
                boolean bl = true;
                for (CharSequence charSequence : scopeAwareMethods) {
                    boolean bl4;
                    if (!bl4) {
                        scopeMethodsString.append(',');
                    }
                    bl4 = false;
                    scopeMethodsString.append('\"').append(charSequence).append('\"');
                }
                this.out.println("        ASTInspector.addScopeAwareMethods(" + scopeMethodsString + ");");
            }
            this.out.println("    }");
            this.out.println("}");
            this.out.close();
            this.out = null;
            new File(SRC_GEN_DIR).mkdirs();
            FileOutputStream fos = new FileOutputStream(SRC_GEN_DIR + qualifiedName + POPULATOR_SUFFIX + ".java");
            fos.write(bytes2.toByteArray());
            fos.close();
        }
        catch (IOException ioe) {
            LOG.severe("FAILED TO GENERATE: " + ioe);
            System.exit(1);
        }
    }

    public void processMethodDeclarations(Map<CharSequence, List<ExecutableElement>> declarations) {
        for (Map.Entry<CharSequence, List<ExecutableElement>> entry : declarations.entrySet()) {
            List<ExecutableElement> list2 = entry.getValue();
            if (list2.size() == 1) {
                this.processMethodDeclaration(list2.get(0));
                continue;
            }
            this.processMethodDeclarationMulti(list2.get(0));
        }
    }

    public void processMethodDeclaration(ExecutableElement method2) {
        JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
        if (anno != null && this.out != null) {
            boolean isStatic = method2.getModifiers().contains((Object)Modifier.STATIC);
            CharSequence qualifiedName = this.getActualQualifiedName((TypeElement)method2.getEnclosingElement());
            boolean hasContext = false;
            boolean hasBlock = false;
            StringBuffer buffer = new StringBuffer();
            boolean first2 = true;
            for (VariableElement variableElement : method2.getParameters()) {
                if (!first2) {
                    buffer.append(", ");
                }
                first2 = false;
                buffer.append(variableElement.asType().toString());
                buffer.append(".class");
                hasContext |= variableElement.asType().toString().equals("org.jruby.runtime.ThreadContext");
                hasBlock |= variableElement.asType().toString().equals("org.jruby.runtime.Block");
            }
            int actualRequired = this.calculateActualRequired(method2, method2.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
            String string2 = CodegenUtils.getAnnotatedBindingClassName(method2.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), false, anno.frame());
            String implClass = anno.meta() ? "singletonClass" : "cls";
            this.out.println("        javaMethod = new " + string2 + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ");");
            this.out.println("        populateMethod(javaMethod, " + AnnotationBinder.getArityValue(anno, actualRequired) + ", \"" + method2.getSimpleName() + "\", " + isStatic + ", " + "CallConfiguration." + AnnotationBinder.getCallConfigNameByAnno(anno) + ", " + anno.notImplemented() + ", " + ((TypeElement)method2.getEnclosingElement()).getQualifiedName() + ".class, " + "\"" + method2.getSimpleName() + "\", " + method2.getReturnType().toString() + ".class, " + "new Class[] {" + buffer.toString() + "});");
            this.generateMethodAddCalls(method2, anno);
        }
    }

    public void processMethodDeclarationMulti(ExecutableElement method2) {
        JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
        if (anno != null && this.out != null) {
            boolean isStatic = method2.getModifiers().contains((Object)Modifier.STATIC);
            CharSequence qualifiedName = this.getActualQualifiedName((TypeElement)method2.getEnclosingElement());
            boolean hasContext = false;
            boolean hasBlock = false;
            StringBuffer buffer = new StringBuffer();
            boolean first2 = true;
            for (VariableElement variableElement : method2.getParameters()) {
                if (!first2) {
                    buffer.append(", ");
                }
                first2 = false;
                buffer.append(variableElement.asType().toString());
                buffer.append(".class");
                hasContext |= variableElement.asType().toString().equals("org.jruby.runtime.ThreadContext");
                hasBlock |= variableElement.asType().toString().equals("org.jruby.runtime.Block");
            }
            int actualRequired = this.calculateActualRequired(method2, method2.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
            String string2 = CodegenUtils.getAnnotatedBindingClassName(method2.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), true, anno.frame());
            String implClass = anno.meta() ? "singletonClass" : "cls";
            this.out.println("        javaMethod = new " + string2 + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ");");
            this.out.println("        populateMethod(javaMethod, -1, \"" + method2.getSimpleName() + "\", " + isStatic + ", " + "CallConfiguration." + AnnotationBinder.getCallConfigNameByAnno(anno) + ", " + anno.notImplemented() + ", " + ((TypeElement)method2.getEnclosingElement()).getQualifiedName() + ".class, " + "\"" + method2.getSimpleName() + "\", " + method2.getReturnType().toString() + ".class, " + "new Class[] {" + buffer.toString() + "});");
            this.generateMethodAddCalls(method2, anno);
        }
    }

    private void addCoreMethodMapping(CharSequence rubyName, ExecutableElement decl, PrintStream out) {
        out.println(new StringBuilder(50).append("        runtime.addBoundMethod(").append('\"').append(((TypeElement)decl.getEnclosingElement()).getQualifiedName()).append('\"').append(',').append('\"').append(decl.getSimpleName()).append('\"').append(',').append('\"').append(rubyName).append('\"').append(");").toString());
    }

    private CharSequence getActualQualifiedName(TypeElement td) {
        if (td.getNestingKind() == NestingKind.MEMBER) {
            return this.getActualQualifiedName((TypeElement)td.getEnclosingElement()) + "$" + td.getSimpleName();
        }
        return td.getQualifiedName().toString();
    }

    private int calculateActualRequired(ExecutableElement md, int paramsLength, int optional, boolean rest2, boolean isStatic, boolean hasContext, boolean hasBlock) {
        int actualRequired;
        if (optional == 0 && !rest2) {
            int args2 = paramsLength;
            if (args2 == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args2;
                }
                if (hasContext) {
                    --args2;
                }
                if (hasBlock) {
                    --args2;
                }
                actualRequired = args2;
            }
        } else {
            int args3 = paramsLength;
            if (args3 == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args3;
                }
                if (hasContext) {
                    --args3;
                }
                if (hasBlock) {
                    --args3;
                }
                actualRequired = --args3;
            }
            if (actualRequired != 0) {
                throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported: " + ((TypeElement)md.getEnclosingElement()).getQualifiedName() + "." + md.toString());
            }
        }
        return actualRequired;
    }

    public void generateMethodAddCalls(ExecutableElement md, JRubyMethod jrubyMethod) {
        if (jrubyMethod.meta()) {
            this.defineMethodOnClass("javaMethod", "singletonClass", jrubyMethod, md);
        } else {
            this.defineMethodOnClass("javaMethod", "cls", jrubyMethod, md);
            if (jrubyMethod.module()) {
                this.out.println("        moduleMethod = populateModuleMethod(cls, javaMethod);");
                this.defineMethodOnClass("moduleMethod", "singletonClass", jrubyMethod, md);
            }
        }
    }

    private void defineMethodOnClass(String methodVar, String classVar, JRubyMethod jrubyMethod, ExecutableElement md) {
        CharSequence baseName;
        if (jrubyMethod.name().length == 0) {
            baseName = md.getSimpleName();
            this.out.println("        " + classVar + ".addMethodAtBootTimeOnly(\"" + baseName + "\", " + methodVar + ");");
        } else {
            baseName = jrubyMethod.name()[0];
            for (String name2 : jrubyMethod.name()) {
                this.out.println("        " + classVar + ".addMethodAtBootTimeOnly(\"" + name2 + "\", " + methodVar + ");");
            }
        }
        if (jrubyMethod.alias().length > 0) {
            for (String alias2 : jrubyMethod.alias()) {
                this.out.println("        " + classVar + ".defineAlias(\"" + alias2 + "\", \"" + baseName + "\");");
            }
        }
    }

    public static void addMethodNamesToSet(Set<String> set, JRubyMethod jrubyMethod, String simpleName) {
        if (jrubyMethod.name().length == 0) {
            set.add(simpleName);
        } else {
            set.addAll(Arrays.asList(jrubyMethod.name()));
        }
        if (jrubyMethod.alias().length > 0) {
            set.addAll(Arrays.asList(jrubyMethod.alias()));
        }
    }

    public static int getArityValue(JRubyMethod anno, int actualRequired) {
        if (anno.optional() > 0 || anno.rest()) {
            return -(actualRequired + 1);
        }
        return actualRequired;
    }

    public static String getCallConfigNameByAnno(JRubyMethod anno) {
        return AnnotationBinder.getCallConfigName(anno.frame(), anno.scope());
    }

    public static String getCallConfigName(boolean frame, boolean scope) {
        if (frame) {
            if (scope) {
                return "FrameFullScopeFull";
            }
            return "FrameFullScopeNone";
        }
        if (scope) {
            return "FrameNoneScopeFull";
        }
        return "FrameNoneScopeNone";
    }
}

