/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.JZlib;
import java.util.ArrayList;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.zlib.JZlibDeflate;
import org.jruby.ext.zlib.JZlibInflate;
import org.jruby.ext.zlib.JZlibRubyGzipReader;
import org.jruby.ext.zlib.JZlibRubyGzipWriter;
import org.jruby.ext.zlib.RubyGzipFile;
import org.jruby.ext.zlib.ZStream;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Adler32Ext;
import org.jruby.util.ByteList;
import org.jruby.util.CRC32Ext;

@JRubyModule(name={"Zlib"})
public class RubyZlib {
    public static final String ZLIB_VERSION = "1.2.3.3";
    public static final String VERSION = "0.6.0";
    private static final long[] crctab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};

    public static RubyModule createZlibModule(Ruby runtime) {
        RubyModule mZlib = runtime.defineModule("Zlib");
        mZlib.defineAnnotatedMethods(RubyZlib.class);
        RubyClass cStandardError = runtime.getStandardError();
        RubyClass cZlibError = mZlib.defineClassUnder("Error", cStandardError, cStandardError.getAllocator());
        mZlib.defineClassUnder("StreamEnd", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("StreamError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("BufError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("NeedDict", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("MemError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("VersionError", cZlibError, cZlibError.getAllocator());
        mZlib.defineClassUnder("DataError", cZlibError, cZlibError.getAllocator());
        RubyClass cGzFile = mZlib.defineClassUnder("GzipFile", runtime.getObject(), RubyGzipFile.GZIPFILE_ALLOCATOR);
        cGzFile.defineAnnotatedMethods(RubyGzipFile.class);
        cGzFile.defineClassUnder("Error", cZlibError, cZlibError.getAllocator());
        RubyClass cGzError = cGzFile.defineClassUnder("Error", cZlibError, cZlibError.getAllocator());
        if (runtime.is1_9()) {
            cGzError.addReadAttribute(runtime.getCurrentContext(), "input");
        }
        cGzError.defineAnnotatedMethods(RubyGzipFile.Error.class);
        cGzFile.defineClassUnder("CRCError", cGzError, cGzError.getAllocator());
        cGzFile.defineClassUnder("NoFooter", cGzError, cGzError.getAllocator());
        cGzFile.defineClassUnder("LengthError", cGzError, cGzError.getAllocator());
        RubyClass cGzReader = mZlib.defineClassUnder("GzipReader", cGzFile, JZlibRubyGzipReader.GZIPREADER_ALLOCATOR);
        cGzReader.includeModule(runtime.getEnumerable());
        cGzReader.defineAnnotatedMethods(JZlibRubyGzipReader.class);
        RubyClass cGzWriter = mZlib.defineClassUnder("GzipWriter", cGzFile, JZlibRubyGzipWriter.GZIPWRITER_ALLOCATOR);
        cGzWriter.defineAnnotatedMethods(JZlibRubyGzipWriter.class);
        mZlib.defineConstant("ZLIB_VERSION", runtime.newString(ZLIB_VERSION));
        mZlib.defineConstant("VERSION", runtime.newString(VERSION));
        mZlib.defineConstant("BINARY", runtime.newFixnum(0));
        mZlib.defineConstant("ASCII", runtime.newFixnum(1));
        mZlib.defineConstant("UNKNOWN", runtime.newFixnum(2));
        mZlib.defineConstant("DEF_MEM_LEVEL", runtime.newFixnum(8));
        mZlib.defineConstant("MAX_MEM_LEVEL", runtime.newFixnum(9));
        mZlib.defineConstant("OS_UNIX", runtime.newFixnum(3));
        mZlib.defineConstant("OS_UNKNOWN", runtime.newFixnum(-1));
        mZlib.defineConstant("OS_CODE", runtime.newFixnum(11));
        mZlib.defineConstant("OS_ZSYSTEM", runtime.newFixnum(8));
        mZlib.defineConstant("OS_VMCMS", runtime.newFixnum(4));
        mZlib.defineConstant("OS_VMS", runtime.newFixnum(2));
        mZlib.defineConstant("OS_RISCOS", runtime.newFixnum(13));
        mZlib.defineConstant("OS_MACOS", runtime.newFixnum(7));
        mZlib.defineConstant("OS_OS2", runtime.newFixnum(6));
        mZlib.defineConstant("OS_AMIGA", runtime.newFixnum(1));
        mZlib.defineConstant("OS_QDOS", runtime.newFixnum(12));
        mZlib.defineConstant("OS_WIN32", runtime.newFixnum(11));
        mZlib.defineConstant("OS_ATARI", runtime.newFixnum(5));
        mZlib.defineConstant("OS_MSDOS", runtime.newFixnum(0));
        mZlib.defineConstant("OS_CPM", runtime.newFixnum(9));
        mZlib.defineConstant("OS_TOPS20", runtime.newFixnum(10));
        mZlib.defineConstant("DEFAULT_STRATEGY", runtime.newFixnum(0));
        mZlib.defineConstant("FILTERED", runtime.newFixnum(1));
        mZlib.defineConstant("HUFFMAN_ONLY", runtime.newFixnum(2));
        mZlib.defineConstant("NO_FLUSH", runtime.newFixnum(0));
        mZlib.defineConstant("SYNC_FLUSH", runtime.newFixnum(2));
        mZlib.defineConstant("FULL_FLUSH", runtime.newFixnum(3));
        mZlib.defineConstant("FINISH", runtime.newFixnum(4));
        mZlib.defineConstant("NO_COMPRESSION", runtime.newFixnum(0));
        mZlib.defineConstant("BEST_SPEED", runtime.newFixnum(1));
        mZlib.defineConstant("DEFAULT_COMPRESSION", runtime.newFixnum(-1));
        mZlib.defineConstant("BEST_COMPRESSION", runtime.newFixnum(9));
        mZlib.defineConstant("MAX_WBITS", runtime.newFixnum(15));
        RubyClass cZStream = mZlib.defineClassUnder("ZStream", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        cZStream.defineAnnotatedMethods(ZStream.class);
        cZStream.undefineMethod("new");
        RubyClass cInflate = mZlib.defineClassUnder("Inflate", cZStream, JZlibInflate.INFLATE_ALLOCATOR);
        cInflate.defineAnnotatedMethods(JZlibInflate.class);
        RubyClass cDeflate = mZlib.defineClassUnder("Deflate", cZStream, JZlibDeflate.DEFLATE_ALLOCATOR);
        cDeflate.defineAnnotatedMethods(JZlibDeflate.class);
        runtime.getKernel().callMethod(runtime.getCurrentContext(), "require", (IRubyObject)runtime.newString("stringio"));
        return mZlib;
    }

    @JRubyMethod(name={"zlib_version"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject zlib_version(IRubyObject recv2) {
        RubyBasicObject res = (RubyBasicObject)((RubyModule)recv2).getConstant("ZLIB_VERSION");
        res.setTaint(true);
        return res;
    }

    @JRubyMethod(name={"crc32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32(IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        long crc2 = 0L;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            crc2 = RubyNumeric.num2long(args2[1]);
        }
        CRC32Ext ext2 = new CRC32Ext((int)crc2);
        if (bytes2 != null) {
            ext2.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        return recv2.getRuntime().newFixnum(ext2.getValue());
    }

    @JRubyMethod(name={"adler32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32(IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        int adler2 = 1;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            adler2 = RubyNumeric.fix2int(args2[1]);
        }
        Adler32Ext ext2 = new Adler32Ext(adler2);
        if (bytes2 != null) {
            ext2.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        return recv2.getRuntime().newFixnum(ext2.getValue());
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject inflate(ThreadContext context, IRubyObject recv2, IRubyObject string2) {
        return JZlibInflate.s_inflate(context, recv2, string2);
    }

    @JRubyMethod(required=1, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject deflate(IRubyObject recv2, IRubyObject[] args2) {
        return JZlibDeflate.s_deflate(recv2, args2);
    }

    @JRubyMethod(name={"crc_table"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc_table(IRubyObject recv2) {
        ArrayList<IRubyObject> ll = new ArrayList<IRubyObject>(crctab.length);
        for (int i2 = 0; i2 < crctab.length; ++i2) {
            ll.add(recv2.getRuntime().newFixnum(crctab[i2]));
        }
        return recv2.getRuntime().newArray(ll);
    }

    @JRubyMethod(name={"crc32_combine"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long crc1 = RubyNumeric.num2long(arg0);
        long crc2 = RubyNumeric.num2long(arg1);
        long len2 = RubyNumeric.num2long(arg2);
        long crc3 = JZlib.crc32_combine(crc1, crc2, len2);
        return recv2.getRuntime().newFixnum(crc3);
    }

    @JRubyMethod(name={"adler32_combine"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long adler1 = RubyNumeric.num2long(arg0);
        long adler2 = RubyNumeric.num2long(arg1);
        long len2 = RubyNumeric.num2long(arg2);
        long adler3 = JZlib.adler32_combine(adler1, adler2, len2);
        return recv2.getRuntime().newFixnum(adler3);
    }

    static RaiseException newZlibError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "Error", message2);
    }

    static RaiseException newBufError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "BufError", message2);
    }

    static RaiseException newDictError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "NeedDict", message2);
    }

    static RaiseException newStreamError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "StreamError", message2);
    }

    static RaiseException newDataError(Ruby runtime, String message2) {
        return RubyZlib.newZlibError(runtime, "DataError", message2);
    }

    static RaiseException newZlibError(Ruby runtime, String klass, String message2) {
        RubyClass errorClass = runtime.getModule("Zlib").getClass(klass);
        return new RaiseException(RubyException.newException(runtime, errorClass, message2), true);
    }

    static RaiseException newGzipFileError(Ruby runtime, String message2) {
        return RubyZlib.newGzipFileError(runtime, "Error", message2);
    }

    static RaiseException newCRCError(Ruby runtime, String message2) {
        return RubyZlib.newGzipFileError(runtime, "CRCError", message2);
    }

    static RaiseException newNoFooter(Ruby runtime, String message2) {
        return RubyZlib.newGzipFileError(runtime, "NoFooter", message2);
    }

    static RaiseException newLengthError(Ruby runtime, String message2) {
        return RubyZlib.newGzipFileError(runtime, "LengthError", message2);
    }

    static RaiseException newGzipFileError(Ruby runtime, String klass, String message2) {
        RubyClass errorClass = runtime.getModule("Zlib").getClass("GzipFile").getClass(klass);
        RubyException excn = RubyException.newException(runtime, errorClass, message2);
        if (runtime.is1_9()) {
            excn.setInstanceVariable("@input", runtime.getNil());
        }
        return new RaiseException(excn, true);
    }

    static int FIXNUMARG(IRubyObject obj, int ifnil) {
        if (obj.isNil()) {
            return ifnil;
        }
        return RubyNumeric.fix2int(obj);
    }

    @JRubyClass(name={"Zlib::DataError"}, parent="Zlib::Error")
    public static class DataError
    extends Error {
    }

    @JRubyClass(name={"Zlib::VersionError"}, parent="Zlib::Error")
    public static class VersionError
    extends Error {
    }

    @JRubyClass(name={"Zlib::MemError"}, parent="Zlib::Error")
    public static class MemError
    extends Error {
    }

    @JRubyClass(name={"Zlib::NeedDict"}, parent="Zlib::Error")
    public static class NeedDict
    extends Error {
    }

    @JRubyClass(name={"Zlib::BufError"}, parent="Zlib::Error")
    public static class BufError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamError"}, parent="Zlib::Error")
    public static class StreamError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamEnd"}, parent="Zlib::Error")
    public static class StreamEnd
    extends Error {
    }

    @JRubyClass(name={"Zlib::Error"}, parent="StandardError")
    public static class Error {
    }
}

