/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Mutex"})
public class Mutex
extends RubyObject
implements DataType {
    ReentrantLock lock = new ReentrantLock();

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static Mutex newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Mutex result2 = new Mutex(context.runtime, (RubyClass)recv2);
        result2.callInit(context, args2, block);
        return result2;
    }

    public Mutex(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public static void setup(Ruby runtime2) {
        RubyClass cMutex = runtime2.getThread().defineClassUnder("Mutex", runtime2.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new Mutex(runtime2, klass);
            }
        });
        cMutex.setReifiedClass(Mutex.class);
        cMutex.defineAnnotatedMethods(Mutex.class);
        runtime2.getObject().setConstant("Mutex", cMutex);
    }

    @JRubyMethod(name={"locked?"})
    public RubyBoolean locked_p(ThreadContext context) {
        return context.runtime.newBoolean(this.lock.isLocked());
    }

    @JRubyMethod
    public RubyBoolean try_lock(ThreadContext context) {
        if (this.lock.isHeldByCurrentThread()) {
            return context.fals;
        }
        return context.runtime.newBoolean(context.getThread().tryLock(this.lock));
    }

    @JRubyMethod
    public IRubyObject lock(ThreadContext context) {
        RubyThread thread2 = context.getThread();
        this.checkRelocking(context);
        if (!thread2.tryLock(this.lock)) {
            try {
                context.getThread().lockInterruptibly(this.lock);
            }
            catch (InterruptedException ex) {
                throw context.runtime.newConcurrencyError("interrupted waiting for mutex");
            }
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject unlock(ThreadContext context) {
        if (!this.lock.isLocked()) {
            throw context.runtime.newThreadError("Mutex is not locked");
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw context.runtime.newThreadError("Mutex is not owned by calling thread");
        }
        boolean hasQueued = this.lock.hasQueuedThreads();
        context.getThread().unlock(this.lock);
        return hasQueued ? context.nil : this;
    }

    @JRubyMethod
    public IRubyObject sleep(ThreadContext context) {
        return this.sleep(context, context.nil);
    }

    @JRubyMethod
    public IRubyObject sleep(ThreadContext context, IRubyObject timeout2) {
        Ruby runtime2 = context.runtime;
        long beg = System.currentTimeMillis();
        try {
            RubyThread thread2 = context.getThread();
            if (timeout2.isNil()) {
                thread2.sleep(this.lock);
            } else {
                double t = RubyTime.convertTimeInterval(context, timeout2);
                long millis = (long)(t * 1000.0);
                if (Double.compare(t, 0.0) != 0 && millis != 0L) {
                    thread2.sleep(this.lock, millis);
                }
            }
        }
        catch (IllegalMonitorStateException imse) {
            throw runtime2.newThreadError("Attempt to unlock a mutex which is not locked");
        }
        catch (InterruptedException ex) {
            context.pollThreadEvents();
        }
        return runtime2.newFixnum((System.currentTimeMillis() - beg) / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject synchronize(ThreadContext context, Block block) {
        this.lock(context);
        try {
            IRubyObject iRubyObject = block.yieldSpecific(context);
            return iRubyObject;
        }
        finally {
            this.unlock(context);
        }
    }

    @JRubyMethod(name={"owned?"})
    public IRubyObject owned_p(ThreadContext context) {
        return context.runtime.newBoolean(this.lock.isHeldByCurrentThread());
    }

    private void checkRelocking(ThreadContext context) {
        if (this.lock.isHeldByCurrentThread()) {
            throw context.runtime.newThreadError("Mutex relocking by same thread");
        }
    }
}

