/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.RubySymbol;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;

public class OpAsgnConstDeclNode
extends Node
implements BinaryOperatorNode {
    private final Node lhs;
    private final RubySymbol operator;
    private final Node rhs;

    public OpAsgnConstDeclNode(int line, Node lhs, RubySymbol operator, Node rhs) {
        super(line, lhs.containsVariableAssignment() || rhs.containsVariableAssignment());
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    public boolean isOr() {
        return CommonByteLists.OR_OR.equals(this.operator.getBytes());
    }

    public boolean isAnd() {
        return CommonByteLists.AMPERSAND_AMPERSAND.equals(this.operator.getBytes());
    }

    @Override
    public Node getFirstNode() {
        return this.lhs;
    }

    @Override
    public Node getSecondNode() {
        return this.rhs;
    }

    public String getOperator() {
        return this.operator.asJavaString();
    }

    public ByteList getByteOperator() {
        return this.operator.getBytes();
    }

    public RubySymbol getSymbolOperator() {
        return this.operator;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitOpAsgnConstDeclNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return OpAsgnConstDeclNode.createList(this.lhs, (Node)new LiteralNode(this.getLine(), this.operator), this.rhs);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNCONSTDECLNODE;
    }
}

