/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonIgnore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHWorkflowRun;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Requester;
import org.kohsuke.github.function.InputStreamFunction;

public class GHWorkflowJob
extends GHObject {
    @JsonIgnore
    private GHRepository owner;
    private String name;
    private String headSha;
    private String startedAt;
    private String completedAt;
    private String status;
    private String conclusion;
    private long runId;
    private String htmlUrl;
    private String checkRunUrl;
    private List<Step> steps = new ArrayList<Step>();

    public String getName() {
        return this.name;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public Date getStartedAt() {
        return GitHubClient.parseDate(this.startedAt);
    }

    public Date getCompletedAt() {
        return GitHubClient.parseDate(this.completedAt);
    }

    public GHWorkflowRun.Status getStatus() {
        return GHWorkflowRun.Status.from(this.status);
    }

    public GHWorkflowRun.Conclusion getConclusion() {
        return GHWorkflowRun.Conclusion.from(this.conclusion);
    }

    public long getRunId() {
        return this.runId;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public URL getCheckRunUrl() {
        return GitHubClient.parseURL(this.checkRunUrl);
    }

    public List<Step> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getRepository() {
        return this.owner;
    }

    public <T> T downloadLogs(InputStreamFunction<T> streamFunction) throws IOException {
        Objects.requireNonNull(streamFunction, "Stream function must not be null");
        return ((Requester)((Requester)this.root.createRequest().method("GET")).withUrlPath(this.getApiRoute(), "logs")).fetchStream(streamFunction);
    }

    private String getApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root.getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/actions/jobs/" + this.getId();
    }

    GHWorkflowJob wrapUp(GHRepository owner) {
        this.owner = owner;
        return this.wrapUp(owner.root);
    }

    GHWorkflowJob wrapUp(GitHub root) {
        this.root = root;
        if (this.owner != null) {
            this.owner.wrap(root);
        }
        return this;
    }

    public static class Step {
        private String name;
        private int number;
        private String startedAt;
        private String completedAt;
        private String status;
        private String conclusion;

        public String getName() {
            return this.name;
        }

        public int getNumber() {
            return this.number;
        }

        public Date getStartedAt() {
            return GitHubClient.parseDate(this.startedAt);
        }

        public Date getCompletedAt() {
            return GitHubClient.parseDate(this.completedAt);
        }

        public GHWorkflowRun.Status getStatus() {
            return GHWorkflowRun.Status.from(this.status);
        }

        public GHWorkflowRun.Conclusion getConclusion() {
            return GHWorkflowRun.Conclusion.from(this.conclusion);
        }
    }
}

