/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GHIOException;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.connector.GitHubConnector;
import org.kohsuke.github.connector.GitHubConnectorRequest;
import org.kohsuke.github.connector.GitHubConnectorResponse;

public final class GitHubConnectorHttpConnectorAdapter
implements GitHubConnector,
HttpConnector {
    final HttpConnector httpConnector;

    public GitHubConnectorHttpConnectorAdapter(HttpConnector httpConnector) {
        this.httpConnector = httpConnector;
    }

    @Nonnull
    public static GitHubConnector adapt(@Nonnull HttpConnector connector) {
        GitHubConnector gitHubConnector = connector == HttpConnector.DEFAULT ? GitHubConnector.DEFAULT : (connector == HttpConnector.OFFLINE ? GitHubConnector.OFFLINE : (connector instanceof GitHubConnector ? (GitHubConnector)((Object)connector) : new GitHubConnectorHttpConnectorAdapter(connector)));
        return gitHubConnector;
    }

    @Override
    @Nonnull
    public HttpURLConnection connect(URL url) throws IOException {
        return this.httpConnector.connect(url);
    }

    @Override
    @Nonnull
    public GitHubConnectorResponse send(GitHubConnectorRequest request) throws IOException {
        HttpURLConnection connection;
        try {
            connection = GitHubConnectorHttpConnectorAdapter.setupConnection(this, request);
        }
        catch (IOException e) {
            throw new GHIOException(e.getMessage(), e);
        }
        int statusCode = connection.getResponseCode();
        Map<String, List<String>> headers = connection.getHeaderFields();
        return new HttpURLConnectionGitHubConnectorResponse(request, statusCode, headers, connection);
    }

    @Nonnull
    private static HttpURLConnection setupConnection(@Nonnull HttpConnector connector, @Nonnull GitHubConnectorRequest request) throws IOException {
        HttpURLConnection connection = connector.connect(request.url());
        GitHubConnectorHttpConnectorAdapter.setRequestMethod(request.method(), connection);
        GitHubConnectorHttpConnectorAdapter.buildRequest(request, connection);
        return connection;
    }

    private static void buildRequest(GitHubConnectorRequest request, HttpURLConnection connection) throws IOException {
        for (Map.Entry<String, List<String>> e : request.allHeaders().entrySet()) {
            List<String> v = e.getValue();
            if (v == null) continue;
            connection.setRequestProperty(e.getKey(), String.join((CharSequence)", ", v));
        }
        if (request.hasBody()) {
            connection.setDoOutput(true);
            IOUtils.copyLarge((InputStream)request.body(), (OutputStream)connection.getOutputStream());
        }
    }

    private static void setRequestMethod(String method, HttpURLConnection connection) throws IOException {
        try {
            connection.setRequestMethod(method);
        }
        catch (ProtocolException e) {
            try {
                Field $method = HttpURLConnection.class.getDeclaredField("method");
                $method.setAccessible(true);
                $method.set(connection, method);
            }
            catch (Exception x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
            try {
                Field $delegate = connection.getClass().getDeclaredField("delegate");
                $delegate.setAccessible(true);
                Object delegate = $delegate.get(connection);
                if (delegate instanceof HttpURLConnection) {
                    HttpURLConnection nested = (HttpURLConnection)delegate;
                    GitHubConnectorHttpConnectorAdapter.setRequestMethod(method, nested);
                }
            }
            catch (NoSuchFieldException $delegate) {
            }
            catch (IllegalAccessException x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
        }
        if (!connection.getRequestMethod().equals(method)) {
            throw new IllegalStateException("Failed to set the request method to " + method);
        }
    }

    public static final class HttpURLConnectionGitHubConnectorResponse
    extends GitHubConnectorResponse.ByteArrayResponse {
        @Nonnull
        private final HttpURLConnection connection;

        HttpURLConnectionGitHubConnectorResponse(@Nonnull GitHubConnectorRequest request, int statusCode, @Nonnull Map<String, List<String>> headers, @Nonnull HttpURLConnection connection) {
            super(request, statusCode, headers);
            this.connection = connection;
        }

        @Override
        @CheckForNull
        protected InputStream rawBodyStream() throws IOException {
            InputStream rawStream = this.connection.getErrorStream();
            if (rawStream == null) {
                rawStream = this.connection.getInputStream();
            }
            return rawStream;
        }

        @Override
        @Nonnull
        @Deprecated
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Internal implementation class. Should not be used externally.")
        public HttpURLConnection toHttpURLConnection() {
            return this.connection;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                IOUtils.closeQuietly((InputStream)this.connection.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

