/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHArtifact;
import org.kohsuke.github.GHArtifactsIterable;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowJobQueryBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.function.InputStreamFunction;
import org.kohsuke.github.internal.EnumUtils;

public class GHWorkflowRun
extends GHObject {
    @JsonProperty(value="repository")
    private GHRepository owner;
    private String name;
    private String displayTitle;
    private long runNumber;
    private long workflowId;
    private long runAttempt;
    private String runStartedAt;
    private String htmlUrl;
    private String jobsUrl;
    private String logsUrl;
    private String checkSuiteUrl;
    private String artifactsUrl;
    private String cancelUrl;
    private String rerunUrl;
    private String workflowUrl;
    private String headBranch;
    private String headSha;
    private GHRepository headRepository;
    private HeadCommit headCommit;
    private String event;
    private String status;
    private String conclusion;
    private GHPullRequest[] pullRequests;

    public String getName() {
        return this.name;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public long getRunNumber() {
        return this.runNumber;
    }

    public long getWorkflowId() {
        return this.workflowId;
    }

    public long getRunAttempt() {
        return this.runAttempt;
    }

    public Date getRunStartedAt() throws IOException {
        return GitHubClient.parseDate(this.runStartedAt);
    }

    public URL getHtmlUrl() throws IOException {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public URL getJobsUrl() {
        return GitHubClient.parseURL(this.jobsUrl);
    }

    public URL getLogsUrl() {
        return GitHubClient.parseURL(this.logsUrl);
    }

    public URL getCheckSuiteUrl() {
        return GitHubClient.parseURL(this.checkSuiteUrl);
    }

    public URL getArtifactsUrl() {
        return GitHubClient.parseURL(this.artifactsUrl);
    }

    public URL getCancelUrl() {
        return GitHubClient.parseURL(this.cancelUrl);
    }

    public URL getRerunUrl() {
        return GitHubClient.parseURL(this.rerunUrl);
    }

    public URL getWorkflowUrl() {
        return GitHubClient.parseURL(this.workflowUrl);
    }

    public String getHeadBranch() {
        return this.headBranch;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public HeadCommit getHeadCommit() {
        return this.headCommit;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getHeadRepository() {
        return this.headRepository;
    }

    public GHEvent getEvent() {
        return EnumUtils.getNullableEnumOrDefault(GHEvent.class, this.event, GHEvent.UNKNOWN);
    }

    public Status getStatus() {
        return Status.from(this.status);
    }

    public Conclusion getConclusion() {
        return Conclusion.from(this.conclusion);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getRepository() {
        return this.owner;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        if (this.pullRequests != null && this.pullRequests.length != 0) {
            for (GHPullRequest pullRequest : this.pullRequests) {
                pullRequest.refresh(pullRequest.getTitle());
            }
            return Collections.unmodifiableList(Arrays.asList(this.pullRequests));
        }
        return Collections.emptyList();
    }

    public void cancel() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("POST")).withUrlPath(this.getApiRoute(), "cancel")).send();
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    public void rerun() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("POST")).withUrlPath(this.getApiRoute(), "rerun")).send();
    }

    public void approve() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("POST")).withUrlPath(this.getApiRoute(), "approve")).send();
    }

    public PagedIterable<GHArtifact> listArtifacts() {
        return new GHArtifactsIterable(this.owner, (GitHubRequest.Builder<?>)this.root().createRequest().withUrlPath(this.getApiRoute(), "artifacts"));
    }

    public <T> T downloadLogs(InputStreamFunction<T> streamFunction) throws IOException {
        Objects.requireNonNull(streamFunction, "Stream function must not be null");
        return ((Requester)((Requester)this.root().createRequest().method("GET")).withUrlPath(this.getApiRoute(), "logs")).fetchStream(streamFunction);
    }

    public void deleteLogs() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), "logs")).send();
    }

    public PagedIterable<GHWorkflowJob> listJobs() {
        return new GHWorkflowJobQueryBuilder(this).latest().list();
    }

    public PagedIterable<GHWorkflowJob> listAllJobs() {
        return new GHWorkflowJobQueryBuilder(this).all().list();
    }

    private String getApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root().getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/actions/runs/" + this.getId();
    }

    GHWorkflowRun wrapUp(GHRepository owner) {
        this.owner = owner;
        return this.wrapUp(owner.root());
    }

    GHWorkflowRun wrapUp(GitHub root) {
        if (this.owner != null && this.pullRequests != null) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.wrap(this.owner);
            }
        }
        return this;
    }

    public static class HeadCommit {
        private String id;
        private String treeId;
        private String message;
        private String timestamp;
        private GitUser author;
        private GitUser committer;

        public String getId() {
            return this.id;
        }

        public String getTreeId() {
            return this.treeId;
        }

        public String getMessage() {
            return this.message;
        }

        public Date getTimestamp() {
            return GitHubClient.parseDate(this.timestamp);
        }

        public GitUser getAuthor() {
            return this.author;
        }

        public GitUser getCommitter() {
            return this.committer;
        }
    }

    public static enum Status {
        QUEUED,
        IN_PROGRESS,
        COMPLETED,
        ACTION_REQUIRED,
        CANCELLED,
        FAILURE,
        NEUTRAL,
        SKIPPED,
        STALE,
        SUCCESS,
        TIMED_OUT,
        REQUESTED,
        WAITING,
        PENDING,
        UNKNOWN;


        public static Status from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Status.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Conclusion {
        ACTION_REQUIRED,
        CANCELLED,
        FAILURE,
        NEUTRAL,
        SUCCESS,
        SKIPPED,
        STALE,
        TIMED_OUT,
        STARTUP_FAILURE,
        UNKNOWN;


        public static Conclusion from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Conclusion.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

