/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import org.apache.catalina.startup.CredentialHandlerRuleSet;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSetBase;

public class RealmRuleSet
extends RuleSetBase {
    private static final int MAX_NESTED_REALM_LEVELS = Integer.getInteger("org.apache.catalina.startup.RealmRuleSet.MAX_NESTED_REALM_LEVELS", 3);
    protected final String prefix;

    public RealmRuleSet() {
        this("");
    }

    public RealmRuleSet(String prefix) {
        this.namespaceURI = null;
        this.prefix = prefix;
    }

    @Override
    public void addRuleInstances(Digester digester) {
        String pattern = this.prefix;
        for (int i = 0; i < MAX_NESTED_REALM_LEVELS; ++i) {
            if (i > 0) {
                pattern = pattern + "/";
            }
            pattern = pattern + "Realm";
            digester.addObjectCreate(pattern, null, "className");
            digester.addSetProperties(pattern);
            if (i == 0) {
                digester.addSetNext(pattern, "setRealm", "org.apache.catalina.Realm");
            } else {
                digester.addSetNext(pattern, "addRealm", "org.apache.catalina.Realm");
            }
            digester.addRuleSet(new CredentialHandlerRuleSet(pattern + "/"));
        }
    }
}

