/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import jodd.typeconverter.Convert;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationDataReader<A extends Annotation, D extends AnnotationData<A>> {
    protected final Class<A> annotationClass;

    protected AnnotationDataReader() {
        this.annotationClass = ReflectUtil.getGenericSupertype(this.getClass());
        if (this.annotationClass == null) {
            throw new IllegalArgumentException("Unable to resolve annotation from generic supertype");
        }
    }

    protected AnnotationDataReader(Class<A> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public Class<A> getAnnotationClass() {
        return this.annotationClass;
    }

    public boolean hasAnnotation(AccessibleObject accessibleObject) {
        return accessibleObject.isAnnotationPresent(this.annotationClass);
    }

    public D readAnnotationData(AccessibleObject accessibleObject) {
        A annotation = accessibleObject.getAnnotation(this.annotationClass);
        if (annotation == null) {
            return null;
        }
        return this.createAnnotationData(annotation);
    }

    protected abstract D createAnnotationData(A var1);

    protected String readStringElement(A annotation, String name) {
        String value = Convert.toString(ReflectUtil.readAnnotationValue(annotation, name));
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    protected Object readElement(A annotation, String name) {
        return ReflectUtil.readAnnotationValue(annotation, name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AnnotationData<N extends Annotation> {
        protected final N annotation;

        protected AnnotationData(N annotation) {
            this.annotation = annotation;
        }

        public N getAnnotation() {
            return this.annotation;
        }
    }
}

