/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.util.JMeterUtils;

public class ServerPanel
extends JPanel {
    private static final long serialVersionUID = -2749091243070619669L;
    private JTextField domain;
    private JTextField port;
    private JTextField connectTimeOut;
    private JTextField responseTimeOut;

    public ServerPanel() {
        this.init();
    }

    public void clear() {
        this.domain.setText("");
        this.port.setText("");
        this.connectTimeOut.setText("");
        this.responseTimeOut.setText("");
    }

    public String getServer() {
        return this.domain.getText();
    }

    public void setServer(String value) {
        this.domain.setText(value);
    }

    public String getPort() {
        return this.port.getText();
    }

    public void setPort(String value) {
        this.port.setText(value);
    }

    public String getConnectTimeout() {
        return this.connectTimeOut.getText();
    }

    public void setConnectTimeout(String value) {
        this.connectTimeOut.setText(value);
    }

    public String getResponseTimeout() {
        return this.responseTimeOut.getText();
    }

    public void setResponseTimeout(String value) {
        this.responseTimeOut.setText(value);
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 0));
        HorizontalPanel webServerPanel = new HorizontalPanel();
        webServerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString("target_server")));
        JPanel domainPanel = this.getDomainPanel();
        JPanel portPanel = this.getPortPanel();
        webServerPanel.add((Component)domainPanel, "Center");
        webServerPanel.add((Component)portPanel, "East");
        HorizontalPanel timeOut = new HorizontalPanel();
        timeOut.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString("web_server_timeout_title")));
        JPanel connPanel = this.getConnectTimeOutPanel();
        JPanel reqPanel = this.getResponseTimeOutPanel();
        ((Container)timeOut).add(connPanel);
        ((Container)timeOut).add(reqPanel);
        VerticalPanel webServerTimeoutPanel = new VerticalPanel();
        webServerTimeoutPanel.add((Component)webServerPanel, "Center");
        webServerTimeoutPanel.add((Component)timeOut, "East");
        VerticalPanel bigPanel = new VerticalPanel();
        ((Container)bigPanel).add(webServerTimeoutPanel);
        this.add(bigPanel);
    }

    private JPanel getDomainPanel() {
        this.domain = new JTextField(20);
        JLabel label = new JLabel(JMeterUtils.getResString("web_server_domain"));
        label.setLabelFor(this.domain);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.domain, "Center");
        return panel;
    }

    private JPanel getPortPanel() {
        this.port = new JTextField(4);
        JLabel label = new JLabel(JMeterUtils.getResString("web_server_port"));
        label.setLabelFor(this.port);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.port, "Center");
        return panel;
    }

    private JPanel getConnectTimeOutPanel() {
        this.connectTimeOut = new JTextField(4);
        JLabel label = new JLabel(JMeterUtils.getResString("web_server_timeout_connect"));
        label.setLabelFor(this.connectTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.connectTimeOut, "Center");
        return panel;
    }

    private JPanel getResponseTimeOutPanel() {
        this.responseTimeOut = new JTextField(4);
        JLabel label = new JLabel(JMeterUtils.getResString("web_server_timeout_response"));
        label.setLabelFor(this.responseTimeOut);
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)label, "West");
        panel.add((Component)this.responseTimeOut, "Center");
        return panel;
    }
}

