/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.ConnectException;
import java.rmi.RemoteException;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class StandardSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final RemoteSampleListener listener;

    @Deprecated
    public StandardSampleSender() {
        this.listener = null;
        log.warn("Constructor only intended for use in testing");
    }

    StandardSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        log.info("Using StandardSampleSender for this test run");
    }

    @Override
    public void testEnded(String host) {
        log.info("Test Ended on " + host);
        try {
            this.listener.testEnded(host);
        }
        catch (RemoteException ex) {
            log.warn("testEnded(host)" + ex);
        }
    }

    @Override
    public void sampleOccurred(SampleEvent e) {
        try {
            this.listener.sampleOccurred(e);
        }
        catch (RemoteException err) {
            if (err.getCause() instanceof ConnectException) {
                throw new JMeterError("Could not return sample", (Throwable)err);
            }
            log.error("sampleOccurred", (Throwable)err);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        log.info("Using StandardSampleSender for this test run");
        return this;
    }
}

