/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;

public class StatisticalSampleResult
extends SampleResult
implements Serializable {
    private static final long serialVersionUID = 240L;
    private int errorCount;
    private long elapsed;

    public StatisticalSampleResult() {
    }

    @Deprecated
    public StatisticalSampleResult(long stamp, long elapsed) {
        super(stamp, elapsed);
        this.elapsed = elapsed;
    }

    public StatisticalSampleResult(SampleResult res, boolean keyOnThreadName) {
        this.setSampleLabel(res.getSampleLabel());
        if (keyOnThreadName) {
            this.setThreadName(res.getThreadName());
        }
        this.setSuccessful(true);
        this.setSampleCount(0);
        this.elapsed = 0L;
    }

    public void add(SampleResult res) {
        this.setSampleCount(this.getSampleCount() + res.getSampleCount());
        this.setBytes(this.getBytes() + res.getBytes());
        if (!res.isSuccessful()) {
            ++this.errorCount;
            this.setSuccessful(false);
        }
        if (this.getStartTime() == 0L) {
            this.setStartTime(res.getStartTime());
        } else {
            this.setStartTime(Math.min(this.getStartTime(), res.getStartTime()));
        }
        this.setEndTime(Math.max(this.getEndTime(), res.getEndTime()));
        this.setLatency(this.getLatency() + res.getLatency());
        this.elapsed += res.getTime();
    }

    @Override
    public long getTime() {
        return this.elapsed;
    }

    @Override
    public long getTimeStamp() {
        return this.getEndTime();
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void setErrorCount(int e) {
        this.errorCount = e;
    }

    public static String getKey(SampleEvent event, boolean keyOnThreadName) {
        StringBuilder sb = new StringBuilder(80);
        sb.append(event.getResult().getSampleLabel());
        if (keyOnThreadName) {
            sb.append('-').append(event.getResult().getThreadName());
        } else {
            sb.append('-').append(event.getThreadGroup());
        }
        return sb.toString();
    }
}

